/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mojang.serialization.DataResult;
import com.mraof.minestuck.player.PlayerIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.common.util.FakePlayer;

public class IdentifierHandler {
    private static final List<PlayerIdentifier> identifierList = new ArrayList<PlayerIdentifier>();
    private static int nextIdentifierId;
    private static int fakePlayerIndex;

    @Nullable
    public static PlayerIdentifier encode(Player player) {
        if (player instanceof FakePlayer || player.getGameProfile() == null) {
            return null;
        }
        for (PlayerIdentifier identifier : identifierList) {
            if (!identifier.appliesTo(player)) continue;
            return identifier;
        }
        UUIDIdentifier identifier = new UUIDIdentifier(nextIdentifierId++, player.getGameProfile().getId());
        identifierList.add(identifier);
        return identifier;
    }

    public static DataResult<Optional<PlayerIdentifier>> loadOptional(CompoundTag tag, String key) {
        if (!tag.contains(key, 8)) {
            return DataResult.success(Optional.empty());
        }
        return IdentifierHandler.load(tag, key).map(Optional::of);
    }

    public static DataResult<PlayerIdentifier> load(CompoundTag tag, String key) {
        return IdentifierHandler.loadNullable(tag, key).flatMap(id -> id.map(DataResult::success).orElse(DataResult.error(() -> "Null identifiers not supported here")));
    }

    public static DataResult<Optional<PlayerIdentifier>> loadNullable(CompoundTag tag, String key) {
        PlayerIdentifier identifier;
        String type = tag.getString(key);
        switch (type) {
            case "null": {
                return DataResult.success(Optional.empty());
            }
            case "uuid": {
                identifier = new UUIDIdentifier(nextIdentifierId, tag.getUUID(key + "_uuid"));
                break;
            }
            case "fake": {
                identifier = new FakeIdentifier(nextIdentifierId, tag.getInt(key + "_count"));
                break;
            }
            default: {
                return DataResult.error(() -> "Can't parse identifier type " + type);
            }
        }
        for (PlayerIdentifier id : identifierList) {
            if (!id.equals(identifier)) continue;
            return DataResult.success(Optional.of(id));
        }
        ++nextIdentifierId;
        identifierList.add(identifier);
        return DataResult.success(Optional.of(identifier));
    }

    @Nullable
    public static PlayerIdentifier getById(int id) {
        for (PlayerIdentifier identifier : identifierList) {
            if (identifier.getId() != id) continue;
            return identifier;
        }
        return null;
    }

    public static PlayerIdentifier createNewFakeIdentifier() {
        FakeIdentifier identifier;
        while (identifierList.contains(identifier = new FakeIdentifier(nextIdentifierId, fakePlayerIndex++))) {
        }
        ++nextIdentifierId;
        identifierList.add(identifier);
        return identifier;
    }

    public static void clear() {
        identifierList.clear();
        nextIdentifierId = 0;
        fakePlayerIndex = 0;
    }

    static {
        fakePlayerIndex = 0;
    }

    private static class UUIDIdentifier
    extends PlayerIdentifier {
        private final UUID uuid;

        private UUIDIdentifier(int id, UUID uuid) {
            super(id);
            this.uuid = uuid;
        }

        @Override
        public boolean appliesTo(Player player) {
            return player.getGameProfile().getId().equals(this.uuid);
        }

        @Override
        public String getUsername() {
            return UsernameCache.containsUUID((UUID)this.uuid) ? UsernameCache.getLastKnownUsername((UUID)this.uuid) : "Unknown (" + this.getId() + ")";
        }

        @Override
        public ServerPlayer getPlayer(MinecraftServer server) {
            PlayerList list;
            PlayerList playerList = list = server == null ? null : server.getPlayerList();
            if (list == null) {
                return null;
            }
            return list.getPlayer(this.uuid);
        }

        @Override
        public String getCommandString() {
            return this.uuid.toString();
        }

        @Override
        public CompoundTag saveToNBT(CompoundTag nbt, String key) {
            nbt.putString(key, "uuid");
            nbt.putUUID(key + "_uuid", this.uuid);
            return nbt;
        }

        public String toString() {
            return "Identifier:" + this.getUsername();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UUIDIdentifier that = (UUIDIdentifier)o;
            return Objects.equals(this.uuid, that.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.uuid);
        }
    }

    private static class FakeIdentifier
    extends PlayerIdentifier {
        private final int count;

        FakeIdentifier(int id, int count) {
            super(id);
            this.count = count;
        }

        @Override
        public boolean appliesTo(Player player) {
            return false;
        }

        @Override
        public String getUsername() {
            return "Fake player " + this.count;
        }

        @Override
        public ServerPlayer getPlayer(MinecraftServer server) {
            return null;
        }

        @Override
        public String getCommandString() {
            return "fake" + this.count;
        }

        @Override
        public CompoundTag saveToNBT(CompoundTag nbt, String key) {
            nbt.putString(key, "fake");
            nbt.putInt(key + "_count", this.count);
            return nbt;
        }

        public String toString() {
            return "Identifier:fake_" + this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FakeIdentifier that = (FakeIdentifier)o;
            return this.count == that.count;
        }

        public int hashCode() {
            return Objects.hash(this.count);
        }
    }
}

