/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class KindAbstratusType {
    private final String unlocalizedName;
    private final ArrayList<ItemType> items = new ArrayList();

    public KindAbstratusType(String unlocName) {
        this.unlocalizedName = unlocName;
    }

    public KindAbstratusType addItemClass(Class<? extends Item> item) {
        this.items.add(new ItemClassType(item));
        return this;
    }

    public KindAbstratusType addItemId(Item item) {
        this.items.add(new ItemIdType(item));
        return this;
    }

    public Component getDisplayName() {
        return Component.translatable((String)("strife." + this.unlocalizedName));
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public boolean partOf(ItemStack item) {
        for (ItemType type : this.items) {
            if (!type.partOf(item)) continue;
            return true;
        }
        return false;
    }

    private static class ItemClassType
    extends ItemType {
        final Class<? extends Item> itemClass;

        ItemClassType(Class<? extends Item> itemClass) {
            this.itemClass = itemClass;
        }

        @Override
        boolean partOf(ItemStack item) {
            return this.itemClass.isInstance(item.getItem().getClass());
        }
    }

    private static class ItemIdType
    extends ItemType {
        final Item item;

        ItemIdType(Item item) {
            this.item = item;
        }

        @Override
        boolean partOf(ItemStack stack) {
            return stack.is(this.item);
        }
    }

    private static abstract class ItemType {
        private ItemType() {
        }

        abstract boolean partOf(ItemStack var1);
    }
}

