/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mraof.minestuck.network.BoondollarDataPacket;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.util.MSAttachments;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class PlayerBoondollars {
    public static long getBoondollars(PlayerData playerData) {
        return (Long)playerData.getData(MSAttachments.BOONDOLLARS);
    }

    public static void addBoondollars(PlayerData playerData, long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Boondollar amount may not be negative.");
        }
        PlayerBoondollars.setBoondollars(playerData, PlayerBoondollars.getBoondollars(playerData) + amount);
    }

    public static void takeBoondollars(PlayerData playerData, long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Boondollar amount may not be negative.");
        }
        PlayerBoondollars.setBoondollars(playerData, PlayerBoondollars.getBoondollars(playerData) - amount);
    }

    public static boolean tryTakeBoondollars(PlayerData playerData, long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Boondollar amount may not be negative.");
        }
        long newAmount = PlayerBoondollars.getBoondollars(playerData) - amount;
        if (newAmount < 0L) {
            return false;
        }
        PlayerBoondollars.setBoondollars(playerData, newAmount);
        return true;
    }

    public static void setBoondollars(PlayerData playerData, long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Boondollar amount may not be negative.");
        }
        if (amount != PlayerBoondollars.getBoondollars(playerData)) {
            playerData.setData(MSAttachments.BOONDOLLARS, amount);
            PlayerBoondollars.sendBoondollars(playerData.getPlayer(), playerData);
        }
    }

    @SubscribeEvent
    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        PlayerData playerData = PlayerData.get(player).orElseThrow();
        PlayerBoondollars.sendBoondollars(player, playerData);
    }

    private static void sendBoondollars(ServerPlayer player, PlayerData playerData) {
        if (player == null) {
            return;
        }
        BoondollarDataPacket packet = BoondollarDataPacket.create(PlayerBoondollars.getBoondollars(playerData));
        player.connection.send((CustomPacketPayload)packet);
    }
}

