/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mojang.serialization.DataResult;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.player.PlayerSavedData;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentHolder;

@ParametersAreNonnullByDefault
public final class PlayerData
extends AttachmentHolder {
    @Nonnull
    final PlayerIdentifier identifier;
    private final MinecraftServer mcServer;

    PlayerData(MinecraftServer mcServer, PlayerIdentifier player) {
        this.mcServer = mcServer;
        this.identifier = player;
    }

    static DataResult<PlayerData> load(MinecraftServer mcServer, CompoundTag nbt) {
        return IdentifierHandler.load(nbt, "player").map(player -> {
            PlayerData playerData = new PlayerData(mcServer, (PlayerIdentifier)player);
            if (nbt.contains("neoforge:attachments", 10)) {
                playerData.deserializeAttachments((HolderLookup.Provider)mcServer.registryAccess(), nbt.getCompound("neoforge:attachments"));
            }
            return playerData;
        });
    }

    public static Optional<PlayerData> get(ServerPlayer player) {
        PlayerIdentifier identifier = IdentifierHandler.encode((Player)player);
        if (identifier == null) {
            return Optional.empty();
        }
        return Optional.of(PlayerSavedData.get(player.server).getOrCreateData(identifier));
    }

    public static PlayerData get(PlayerIdentifier player, Level level) {
        return PlayerSavedData.get(level).getOrCreateData(player);
    }

    public static PlayerData get(PlayerIdentifier player, MinecraftServer server) {
        return PlayerSavedData.get(server).getOrCreateData(player);
    }

    CompoundTag writeToNBT(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.identifier.saveToNBT(nbt, "player");
        CompoundTag attachments = this.serializeAttachments(registries);
        if (attachments != null) {
            nbt.put("neoforge:attachments", (Tag)attachments);
        }
        return nbt;
    }

    @Nullable
    public ServerPlayer getPlayer() {
        return this.identifier.getPlayer(this.mcServer);
    }

    public MinecraftServer getMinecraftServer() {
        return this.mcServer;
    }
}

