/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class PlayerSavedData
extends SavedData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DATA_NAME = "minestuck_player_data";
    private final Map<PlayerIdentifier, PlayerData> dataMap = new HashMap<PlayerIdentifier, PlayerData>();
    @Deprecated
    public final MinecraftServer mcServer;

    private PlayerSavedData(MinecraftServer server) {
        this.mcServer = server;
    }

    public static PlayerSavedData get(Level level) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            throw new IllegalArgumentException("Can't get player data instance on client side! (Got null server from level)");
        }
        return PlayerSavedData.get(server);
    }

    public static PlayerSavedData get(MinecraftServer mcServer) {
        ServerLevel level = mcServer.overworld();
        DimensionDataStorage storage = level.getDataStorage();
        return (PlayerSavedData)storage.computeIfAbsent(PlayerSavedData.factory(mcServer), DATA_NAME);
    }

    private static SavedData.Factory<PlayerSavedData> factory(MinecraftServer mcServer) {
        return new SavedData.Factory(() -> new PlayerSavedData(mcServer), (nbt, registries) -> PlayerSavedData.load(mcServer, nbt));
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        for (PlayerData data : this.dataMap.values()) {
            list.add((Object)data.writeToNBT(registries));
        }
        compound.put("playerData", (Tag)list);
        return compound;
    }

    private static PlayerSavedData load(MinecraftServer server, CompoundTag nbt) {
        PlayerSavedData savedData = new PlayerSavedData(server);
        ListTag list = nbt.getList("playerData", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag dataCompound = list.getCompound(i);
            PlayerData.load(server, dataCompound).resultOrPartial(message -> LOGGER.error("Problem while loading player data: {}", message)).ifPresent(data -> savedData.dataMap.put(data.identifier, (PlayerData)((Object)data)));
        }
        return savedData;
    }

    public PlayerData getOrCreateData(PlayerIdentifier player) {
        Objects.requireNonNull(player);
        return this.dataMap.computeIfAbsent(player, ignored -> new PlayerData(this.mcServer, player));
    }

    public boolean isDirty() {
        return true;
    }
}

