/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.entity.dialogue.condition.Condition;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record Rung(int rung, int backgroundColor, int textColor, long expRequirement, long boondollars, long gristCapacity, Optional<RungCondition> rungCondition) {
    public static final Codec<Rung> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("rung").forGetter(Rung::rung), (App)Codec.INT.fieldOf("background_color").forGetter(Rung::backgroundColor), (App)Codec.INT.fieldOf("text_color").forGetter(Rung::textColor), (App)Codec.LONG.fieldOf("exp_requirement").forGetter(Rung::expRequirement), (App)Codec.LONG.fieldOf("boondollars").forGetter(Rung::boondollars), (App)Codec.LONG.fieldOf("grist_capacity").forGetter(Rung::gristCapacity), (App)RungCondition.CODEC.optionalFieldOf("rungCondition").forGetter(Rung::rungCondition)).apply((Applicative)instance, Rung::new));
    public static final Codec<List<Rung>> LIST_CODEC = Codec.list(CODEC);

    public record RungCondition(Condition.PlayerOnlyCondition condition, String description) {
        public static final Codec<RungCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Condition.PLAYER_ONLY_CODEC.fieldOf("condition").forGetter(RungCondition::condition), (App)Codec.STRING.fieldOf("description").forGetter(RungCondition::description)).apply((Applicative)instance, RungCondition::new));

        public boolean canInitiateRung(ServerPlayer player) {
            Condition.PlayerOnlyCondition playerOnlyCondition = this.condition;
            if (playerOnlyCondition instanceof Condition.PlayerOnlyCondition) {
                Condition.PlayerOnlyCondition playerOnlyCondition2 = playerOnlyCondition;
                return playerOnlyCondition2.test(player);
            }
            return false;
        }
    }

    public record DisplayAttributes(double attackBonus, double healthBoost, double underlingDamageMod, double underlingProtectionMod) {
        public static final StreamCodec<FriendlyByteBuf, DisplayAttributes> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, DisplayAttributes::attackBonus, (StreamCodec)ByteBufCodecs.DOUBLE, DisplayAttributes::healthBoost, (StreamCodec)ByteBufCodecs.DOUBLE, DisplayAttributes::underlingDamageMod, (StreamCodec)ByteBufCodecs.DOUBLE, DisplayAttributes::underlingProtectionMod, DisplayAttributes::new);
    }

    public record DisplayData(int backgroundColor, int textColor, long gristCapacity, Optional<String> description, DisplayAttributes attributes) {
        public static final StreamCodec<FriendlyByteBuf, DisplayData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DisplayData::backgroundColor, (StreamCodec)ByteBufCodecs.INT, DisplayData::textColor, (StreamCodec)ByteBufCodecs.VAR_LONG, DisplayData::gristCapacity, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), DisplayData::description, DisplayAttributes.STREAM_CODEC, DisplayData::attributes, DisplayData::new);
    }

    public record EcheladderAttribute(Holder<Attribute> attribute, ResourceLocation id, double rungMultiplier, float startingValue, AttributeModifier.Operation operation) {
        public static final MapCodec<EcheladderAttribute> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Attribute.CODEC.fieldOf("attribute").forGetter(EcheladderAttribute::attribute), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(EcheladderAttribute::id), (App)Codec.DOUBLE.fieldOf("change_per_rung").forGetter(EcheladderAttribute::rungMultiplier), (App)Codec.FLOAT.fieldOf("value").forGetter(EcheladderAttribute::startingValue), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(EcheladderAttribute::operation)).apply((Applicative)instance, EcheladderAttribute::new));
        public static final Codec<List<EcheladderAttribute>> LIST_CODEC = CODEC.codec().listOf();

        public double getAmount(int rung) {
            return this.rungMultiplier * (double)rung + (double)this.startingValue;
        }

        public void updateAttribute(ServerPlayer player, int rung) {
            AttributeModifier attributeModifier;
            AttributeInstance attributeInstance = player.getAttribute(this.attribute);
            if (attributeInstance.hasModifier((attributeModifier = new AttributeModifier(this.id, this.getAmount(rung), this.operation)).id())) {
                attributeInstance.removeModifier(attributeModifier.id());
            }
            attributeInstance.addPermanentModifier(attributeModifier);
        }
    }

    public record Effect(Holder<MobEffect> mobEffect, int amplifier) {
        public static final MapCodec<Effect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MobEffect.CODEC.fieldOf("effect").forGetter(Effect::mobEffect), (App)Codec.INT.optionalFieldOf("amplifier", (Object)0).forGetter(Effect::amplifier)).apply((Applicative)instance, Effect::new));
    }
}

