/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.data.RungsProvider;
import com.mraof.minestuck.network.RungDisplayDataPacket;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.Rung;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.util.MSAttachments;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class Rungs {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String PATH = "minestuck/config/rungs.json";
    private static final List<Rung> RUNGS = new ArrayList<Rung>();
    private static Collection<RungExtension> RUNG_EXTENSION_LIST = Collections.emptySet();

    public static long getGristCapacity(int rung) {
        return Rungs.getRung(rung).gristCapacity();
    }

    public static long getBoondollarsGained(int rung) {
        return Rungs.getRung(rung).boondollars();
    }

    public static long getProgressReq(int rung) {
        return Rungs.getRung(rung).expRequirement();
    }

    @SubscribeEvent
    private static void onPlayerTickEvent(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!((Boolean)player2.getData(MSAttachments.EFFECT_TOGGLE)).booleanValue()) {
                return;
            }
            if (player2.getCommandSenderWorld().getGameTime() % 380L != 0L) {
                return;
            }
            Optional<PlayerData> data = PlayerData.get(player2);
            if (data.isEmpty()) {
                return;
            }
            int rung = Echeladder.get(data.get()).getRung();
            EnumAspect aspect = Title.getTitle(data.get()).map(Title::heroAspect).orElse(null);
            List<MobEffectInstance> effects = Rungs.getRelevantEffects(aspect, rung);
            if (!effects.isEmpty()) {
                effects.forEach(arg_0 -> ((ServerPlayer)player2).addEffect(arg_0));
                LOGGER.debug("Applied echeladder potion effect(s) to {}", (Object)player2.getDisplayName().getString());
            }
        }
    }

    public static List<MobEffectInstance> getRelevantEffects(@Nullable EnumAspect aspect, int rung) {
        ArrayList<MobEffectInstance> instances = new ArrayList<MobEffectInstance>();
        for (RungExtension extension : RUNG_EXTENSION_LIST) {
            if (!extension.requiredAspect().isEmpty() && extension.requiredAspect().get() != aspect) continue;
            for (RungReq<Rung.Effect> rungEffect : extension.effectList()) {
                if (rungEffect.rung() > rung) continue;
                instances.add(new MobEffectInstance(rungEffect.value().mobEffect(), 600, rungEffect.value().amplifier()));
            }
        }
        return instances;
    }

    public static List<Rung.EcheladderAttribute> getRelevantAttributes(@Nullable EnumAspect aspect, int rung) {
        ArrayList<Rung.EcheladderAttribute> attributes = new ArrayList<Rung.EcheladderAttribute>();
        for (RungExtension extension : RUNG_EXTENSION_LIST) {
            if (!extension.requiredAspect().isEmpty() && extension.requiredAspect().get() != aspect) continue;
            for (RungReq<Rung.EcheladderAttribute> rungAttribute : extension.attributeList()) {
                if (rungAttribute.rung() > rung) continue;
                attributes.add(rungAttribute.value());
            }
        }
        return attributes;
    }

    public static int finalRung() {
        return RUNGS.size() - 1;
    }

    public static int getMaxAttainableRung(ServerPlayer serverPlayer) {
        Rung rung;
        Optional<Rung.RungCondition> rungCondition;
        int maxRung = 0;
        Iterator<Rung> iterator = RUNGS.iterator();
        while (iterator.hasNext() && (!(rungCondition = (rung = iterator.next()).rungCondition()).isPresent() || rungCondition.get().canInitiateRung(serverPlayer))) {
            ++maxRung;
        }
        return maxRung;
    }

    public List<Rung> getRungs() {
        return RUNGS;
    }

    public static Rung getRung(int rung) {
        if (RUNGS.size() > rung) {
            return RUNGS.get(rung);
        }
        return RUNGS.getLast();
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        RUNGS.clear();
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new Loader());
        event.addListener((PreparableReloadListener)new ExtensionsLoader());
    }

    @SubscribeEvent
    private static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)event.getPlayer(), (CustomPacketPayload)Rungs.createDisplayDataPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)Rungs.createDisplayDataPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static RungDisplayDataPacket createDisplayDataPacket() {
        List<Rung.DisplayData> rungList = RUNGS.stream().map(rung -> {
            Rung.DisplayAttributes attributes = new Rung.DisplayAttributes(Rungs.getAttributeAmount(rung.rung(), RungsProvider.DAMAGE_BOOST_ID), Rungs.getAttributeAmount(rung.rung(), RungsProvider.HEALTH_BOOST_ID), 1.0 + Rungs.getAttributeAmount(rung.rung(), RungsProvider.UNDERLING_DAMAGE_ID), 1.0 + Rungs.getAttributeAmount(rung.rung(), RungsProvider.UNDERLING_PROTECTION_ID));
            return new Rung.DisplayData(rung.backgroundColor(), rung.textColor(), rung.gristCapacity(), rung.rungCondition().map(Rung.RungCondition::description), attributes);
        }).toList();
        return new RungDisplayDataPacket(rungList);
    }

    private static double getAttributeAmount(int rung, ResourceLocation id) {
        for (Rung.EcheladderAttribute echeladderAttribute : Rungs.getRelevantAttributes(null, rung)) {
            if (!echeladderAttribute.id().equals((Object)id)) continue;
            return echeladderAttribute.getAmount(rung);
        }
        return 0.0;
    }

    private record RungExtension(Optional<EnumAspect> requiredAspect, List<RungReq<Rung.EcheladderAttribute>> attributeList, List<RungReq<Rung.Effect>> effectList) {
        static Codec<RungExtension> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EnumAspect.CODEC.optionalFieldOf("aspect").forGetter(RungExtension::requiredAspect), (App)RungReq.codec(Rung.EcheladderAttribute.CODEC).listOf().optionalFieldOf("attributes", Collections.emptyList()).forGetter(RungExtension::attributeList), (App)RungReq.codec(Rung.Effect.CODEC).listOf().optionalFieldOf("effects", Collections.emptyList()).forGetter(RungExtension::effectList)).apply((Applicative)instance, RungExtension::new));
    }

    private record RungReq<T>(int rung, T value) {
        static <T> Codec<RungReq<T>> codec(MapCodec<T> innerCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("rung", (Object)0).forGetter(RungReq::rung), (App)innerCodec.forGetter(RungReq::value)).apply((Applicative)instance, RungReq::new));
        }
    }

    private static final class Loader
    extends SimplePreparableReloadListener<List<Rung>> {
        private Loader() {
        }

        protected List<Rung> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
            return Loader.loadRungList(resourceManager);
        }

        private static List<Rung> loadRungList(ResourceManager resourceManager) {
            ResourceLocation location = Minestuck.id(Rungs.PATH);
            Optional potentialResource = resourceManager.getResource(location);
            return potentialResource.flatMap(resource -> {
                Optional optional;
                block8: {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement json = JsonParser.parseReader((Reader)reader);
                        optional = Rung.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(message -> LOGGER.error("Problem parsing rungs json at: {}. This means there is no data for rungs. Reason: {}", (Object)location, message));
                        if (reader == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException ignored) {
                            return Optional.empty();
                        }
                    }
                    ((Reader)reader).close();
                }
                return optional;
            }).orElse(Collections.emptyList());
        }

        protected void apply(List<Rung> rungs, ResourceManager resourceManager, ProfilerFiller profiler) {
            RUNGS.clear();
            RUNGS.addAll(rungs);
            RUNGS.sort(Comparator.comparingInt(Rung::rung));
        }
    }

    private static final class ExtensionsLoader
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new GsonBuilder().create();

        public ExtensionsLoader() {
            super(GSON, "minestuck/rung_extension");
        }

        protected void apply(Map<ResourceLocation, JsonElement> jsonElements, ResourceManager resourceManager, ProfilerFiller profiler) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElements.entrySet()) {
                RungExtension.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(message -> LOGGER.error("Couldn't parse rung extension {}: {}", entry.getKey(), message)).ifPresent(arg_0 -> ((ImmutableList.Builder)listBuilder).add(arg_0));
            }
            RUNG_EXTENSION_LIST = listBuilder.build();
        }
    }
}

