/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.player;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.network.TitleDataPacket;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.EnumClass;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.util.MSAttachments;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public record Title(EnumClass heroClass, EnumAspect heroAspect) {
    public static final StreamCodec<FriendlyByteBuf, Title> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(EnumClass.class), Title::heroClass, (StreamCodec)NeoForgeStreamCodecs.enumCodec(EnumAspect.class), Title::heroAspect, Title::new);
    public static final String FORMAT = "title.format";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Codec<EnumClass> CLASS_CODEC = Codec.STRING.xmap(EnumClass::valueOf, Enum::name);
    public static final Codec<EnumAspect> ASPECT_CODEC = Codec.STRING.xmap(EnumAspect::valueOf, Enum::name);
    public static final Codec<Title> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EnumClass.CODEC.fieldOf("class").forGetter(Title::heroClass), (App)EnumAspect.CODEC.fieldOf("aspect").forGetter(Title::heroAspect)).apply((Applicative)instance, Title::new));

    @SubscribeEvent
    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Title.getTitle(player).ifPresent(title -> player.connection.send((CustomPacketPayload)TitleDataPacket.create(title)));
    }

    public static boolean isPlayerOfAspect(ServerPlayer player, EnumAspect aspect) {
        return Title.getTitle(player).map(title -> title.heroAspect() == aspect).orElse(false);
    }

    public static Optional<Title> getTitle(ServerPlayer player) {
        return PlayerData.get(player).flatMap(Title::getTitle);
    }

    public static Optional<Title> getTitle(PlayerIdentifier playerId, MinecraftServer mcServer) {
        return Title.getTitle(PlayerData.get(playerId, mcServer));
    }

    public static Optional<Title> getTitle(PlayerData playerData) {
        return playerData.getExistingData(MSAttachments.TITLE);
    }

    public static void setTitle(PlayerData playerData, Title newTitle) {
        if (Title.getTitle(playerData).isPresent()) {
            throw new IllegalStateException("Can't set title for player " + playerData.identifier.getUsername() + " because they already have one");
        }
        playerData.setData(MSAttachments.TITLE, newTitle);
        ServerPlayer player = playerData.getPlayer();
        if (player != null) {
            player.connection.send((CustomPacketPayload)TitleDataPacket.create(newTitle));
        }
    }

    @Override
    public String toString() {
        return this.heroClass.toString() + " of " + this.heroAspect.toString();
    }

    public Component asTextComponent() {
        return Component.translatable((String)FORMAT, (Object[])new Object[]{this.heroClass.asTextComponent(), this.heroAspect.asTextComponent()});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Title) {
            Title title = (Title)obj;
            return title.heroClass.equals((Object)this.heroClass) && title.heroAspect.equals((Object)this.heroAspect);
        }
        return false;
    }

    private static String makeNBTPrefix(String prefix) {
        return prefix != null && !prefix.isEmpty() ? prefix + "_" : "";
    }

    public static Title read(CompoundTag nbt, String keyPrefix) {
        keyPrefix = Title.makeNBTPrefix(keyPrefix);
        EnumClass c = EnumClass.getClassFromInt(nbt.getByte(keyPrefix + "class"));
        EnumAspect a = EnumAspect.getAspectFromInt(nbt.getByte(keyPrefix + "aspect"));
        return new Title(c, a);
    }

    public static Title tryRead(CompoundTag nbt, String keyPrefix) {
        if (nbt.contains((keyPrefix = Title.makeNBTPrefix(keyPrefix)) + "class", 99)) {
            EnumClass c = EnumClass.getClassFromInt(nbt.getByte(keyPrefix + "class"));
            EnumAspect a = EnumAspect.getAspectFromInt(nbt.getByte(keyPrefix + "aspect"));
            if (c != null && a != null) {
                return new Title(c, a);
            }
        }
        return null;
    }

    public CompoundTag write(CompoundTag nbt, String keyPrefix) {
        keyPrefix = Title.makeNBTPrefix(keyPrefix);
        nbt.putByte(keyPrefix + "class", (byte)EnumClass.getIntFromClass(this.heroClass));
        nbt.putByte(keyPrefix + "aspect", (byte)EnumAspect.getIntFromAspect(this.heroAspect));
        return nbt;
    }
}

