/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.computer.ComputerReference;
import com.mraof.minestuck.computer.ISburbComputer;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ActiveConnection {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PlayerIdentifier client;
    private ComputerReference clientComputer;
    private final PlayerIdentifier server;
    private ComputerReference serverComputer;
    @Nullable
    public Vec3 lastEditmodePosition;

    ActiveConnection(PlayerIdentifier client, ComputerReference clientComputer, PlayerIdentifier server, ComputerReference serverComputer) {
        this.client = client;
        this.clientComputer = clientComputer;
        this.server = server;
        this.serverComputer = serverComputer;
    }

    ActiveConnection(ISburbComputer client, ISburbComputer server) {
        this(client.getOwner(), client.createReference(), server.getOwner(), server.createReference());
    }

    public boolean isClient(ISburbComputer computer) {
        return this.clientComputer().matches(computer) && this.client().equals(computer.getOwner());
    }

    public boolean isServer(ISburbComputer computer) {
        return this.serverComputer().matches(computer) && this.server().equals(computer.getOwner());
    }

    public boolean hasPlayer(PlayerIdentifier player) {
        return this.client().equals(player) || this.server().equals(player);
    }

    public PlayerIdentifier client() {
        return this.client;
    }

    public ComputerReference clientComputer() {
        return this.clientComputer;
    }

    public PlayerIdentifier server() {
        return this.server;
    }

    public ComputerReference serverComputer() {
        return this.serverComputer;
    }

    void updateComputer(ISburbComputer oldComputer, ComputerReference newComputer) {
        Objects.requireNonNull(newComputer);
        if (this.clientComputer.matches(oldComputer)) {
            this.clientComputer = newComputer;
        }
        if (this.serverComputer.matches(oldComputer)) {
            this.serverComputer = newComputer;
        }
    }

    CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        this.client.saveToNBT(tag, "client");
        this.server.saveToNBT(tag, "server");
        ComputerReference.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.clientComputer).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(computerTag -> tag.put("client_computer", computerTag));
        ComputerReference.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.serverComputer).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(computerTag -> tag.put("server_computer", computerTag));
        return tag;
    }

    static DataResult<ActiveConnection> read(CompoundTag tag) {
        return DataResult.unbox((App)DataResult.instance().apply4(ActiveConnection::new, IdentifierHandler.load(tag, "client"), (App)ComputerReference.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("client_computer")), IdentifierHandler.load(tag, "server"), (App)ComputerReference.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("server_computer"))));
    }
}

