/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.computer.ComputerReference;
import com.mraof.minestuck.computer.ISburbComputer;
import com.mraof.minestuck.computer.SburbClientData;
import com.mraof.minestuck.computer.SburbServerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.ActiveConnection;
import com.mraof.minestuck.skaianet.ClientAccess;
import com.mraof.minestuck.skaianet.ComputerWaitingList;
import com.mraof.minestuck.skaianet.ServerAccess;
import com.mraof.minestuck.skaianet.SkaianetData;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class ComputerInteractions {
    public static final String STOP_RESUME = "minestuck.stop_resume_message";
    private final SkaianetData skaianetData;
    private final ComputerWaitingList openedServers;
    private final ComputerWaitingList resumingClients;
    private final ComputerWaitingList resumingServers;

    ComputerInteractions(SkaianetData skaianetData) {
        this.skaianetData = skaianetData;
        this.openedServers = new ComputerWaitingList(skaianetData, ComputerInteractions::isValidServerOpenOrResuming, "opened server");
        this.resumingClients = new ComputerWaitingList(skaianetData, ComputerInteractions::isValidClientResuming, "resuming client");
        this.resumingServers = new ComputerWaitingList(skaianetData, ComputerInteractions::isValidServerOpenOrResuming, "resuming server");
    }

    ComputerInteractions(SkaianetData skaianetData, CompoundTag tag) {
        this(skaianetData);
        this.openedServers.read(tag.getList("serversOpen", 10));
        this.resumingClients.read(tag.getList("resumingClients", 10));
        this.resumingServers.read(tag.getList("resumingServers", 10));
    }

    void write(CompoundTag tag) {
        tag.put("serversOpen", (Tag)this.openedServers.write());
        tag.put("resumingClients", (Tag)this.resumingClients.write());
        tag.put("resumingServers", (Tag)this.resumingServers.write());
    }

    private static boolean isValidClientResuming(ISburbComputer computer) {
        return computer.getSburbClientData().map(SburbClientData::isResuming).orElse(false);
    }

    private static boolean isValidServerOpenOrResuming(ISburbComputer computer) {
        return computer.getSburbServerData().map(SburbServerData::isOpen).orElse(false);
    }

    public static ComputerInteractions get(MinecraftServer mcServer) {
        return SkaianetData.get((MinecraftServer)mcServer).computerInteractions;
    }

    public boolean hasResumingClient(PlayerIdentifier identifier) {
        return this.resumingClients.contains(identifier);
    }

    public boolean hasResumingServer(PlayerIdentifier identifier) {
        return this.resumingServers.contains(identifier) || this.openedServers.contains(identifier);
    }

    Iterable<PlayerIdentifier> openServerPlayers() {
        return this.openedServers.getPlayers();
    }

    public void connectToServerPlayer(ISburbComputer computer, PlayerIdentifier serverPlayer) {
        Optional<ClientAccess> client = ClientAccess.tryGet(computer);
        if (client.isEmpty()) {
            return;
        }
        PlayerIdentifier player = computer.getOwner();
        if (computer.createReference().isInNether()) {
            return;
        }
        if (this.isClientActive(player)) {
            return;
        }
        this.openedServers.useAsServerAndRemoveOnSuccess(serverPlayer, server -> this.skaianetData.connections.tryConnect((ClientAccess)client.get(), (ServerAccess)server));
    }

    public void resumeClientConnection(ISburbComputer clientComputer) {
        Optional<ClientAccess> client = ClientAccess.tryGet(clientComputer);
        if (client.isEmpty()) {
            return;
        }
        PlayerIdentifier player = clientComputer.getOwner();
        if (clientComputer.createReference().isInNether() || this.isClientActive(player)) {
            return;
        }
        if (!this.skaianetData.connections.hasPrimaryConnectionForClient(player)) {
            return;
        }
        Optional<PlayerIdentifier> serverPlayer = this.skaianetData.connections.primaryPartnerForClient(player);
        if (serverPlayer.isPresent() && this.resumingServers.contains(serverPlayer.get())) {
            this.resumingServers.useAsServerAndRemoveOnSuccess(serverPlayer.get(), server -> this.skaianetData.connections.tryConnect((ClientAccess)client.get(), (ServerAccess)server));
            return;
        }
        if (serverPlayer.isPresent() && this.openedServers.contains(serverPlayer.get())) {
            this.openedServers.useAsServerAndRemoveOnSuccess(serverPlayer.get(), server -> this.skaianetData.connections.tryConnect((ClientAccess)client.get(), (ServerAccess)server));
            return;
        }
        client.get().data().setIsResuming(true);
        this.resumingClients.put(player, clientComputer.createReference());
    }

    public void resumeServerConnection(ISburbComputer serverComputer) {
        Optional<ServerAccess> server = ServerAccess.tryGet(serverComputer);
        if (server.isEmpty()) {
            return;
        }
        PlayerIdentifier player = serverComputer.getOwner();
        if (serverComputer.createReference().isInNether() || this.hasResumingServer(player)) {
            return;
        }
        Optional<PlayerIdentifier> clientPlayer = this.skaianetData.connections.primaryPartnerForServer(player);
        if (clientPlayer.isEmpty()) {
            return;
        }
        if (this.resumingClients.contains(clientPlayer.get())) {
            this.resumingClients.useAsClientAndRemoveOnSuccess(clientPlayer.get(), client -> this.skaianetData.connections.tryConnect((ClientAccess)client, (ServerAccess)server.get()));
            return;
        }
        server.get().data().setIsOpen(true);
        this.resumingServers.put(player, serverComputer.createReference());
    }

    public void openServer(ISburbComputer serverComputer) {
        Optional<ServerAccess> server = ServerAccess.tryGet(serverComputer);
        if (server.isEmpty()) {
            return;
        }
        PlayerIdentifier player = serverComputer.getOwner();
        if (serverComputer.createReference().isInNether() || this.hasResumingServer(player)) {
            return;
        }
        Optional<PlayerIdentifier> primaryClient = this.skaianetData.connections.primaryPartnerForServer(player);
        if (primaryClient.isPresent() && this.resumingClients.contains(primaryClient.get())) {
            this.resumingClients.useAsClientAndRemoveOnSuccess(primaryClient.get(), client -> this.skaianetData.connections.tryConnect((ClientAccess)client, (ServerAccess)server.get()));
            return;
        }
        server.get().data().setIsOpen(true);
        this.openedServers.put(player, serverComputer.createReference());
    }

    public void closeClientConnectionRemotely(PlayerIdentifier player) {
        if (this.resumingClients.contains(player)) {
            this.resumingClients.useAsClientAndRemoveOnSuccess(player, client -> {
                client.data().setIsResuming(false);
                client.data().setEventMessage(STOP_RESUME);
                return true;
            });
        } else {
            this.skaianetData.connections.getActiveConnection(player).ifPresent(this.skaianetData.connections::closeConnection);
        }
    }

    public void closeClientConnection(ISburbComputer computer) {
        PlayerIdentifier owner = computer.getOwner();
        if (this.resumingClients.contains(computer)) {
            this.resumingClients.remove(owner);
            computer.getSburbClientData().ifPresent(sburbClientData -> {
                sburbClientData.setIsResuming(false);
                sburbClientData.setEventMessage(STOP_RESUME);
            });
        } else {
            this.skaianetData.connections.getClientConnection(computer).ifPresent(connection -> this.skaianetData.connections.closeConnection((ActiveConnection)connection, computer, null));
        }
    }

    public void closeServerConnection(ISburbComputer computer) {
        ComputerInteractions.checkAndCloseFromServerList(computer, this.openedServers);
        ComputerInteractions.checkAndCloseFromServerList(computer, this.resumingServers);
        this.skaianetData.connections.getServerConnection(computer).ifPresent(connection -> this.skaianetData.connections.closeConnection((ActiveConnection)connection, null, computer));
    }

    private static void checkAndCloseFromServerList(ISburbComputer computer, ComputerWaitingList map) {
        PlayerIdentifier owner = computer.getOwner();
        if (map.contains(computer)) {
            map.remove(owner);
            computer.getSburbServerData().ifPresent(sburbServerData -> {
                sburbServerData.setIsOpen(false);
                sburbServerData.setEventMessage(STOP_RESUME);
            });
        }
    }

    public void movingComputer(ComputerBlockEntity oldBE, ComputerBlockEntity newBE) {
        ComputerReference oldRef = ComputerReference.of(oldBE);
        ComputerReference newRef = ComputerReference.of(newBE);
        if (!Objects.equals(oldBE.getOwner(), newBE.getOwner())) {
            throw new IllegalStateException("Moving computers with different owners! (" + String.valueOf(oldBE.getOwner()) + " and " + String.valueOf(newBE.getOwner()) + ")");
        }
        this.skaianetData.connections.activeConnections().forEach(c -> c.updateComputer(oldBE, newRef));
        this.resumingClients.replace(oldBE.getOwner(), oldRef, newRef);
        this.resumingServers.replace(oldBE.getOwner(), oldRef, newRef);
        this.openedServers.replace(oldBE.getOwner(), oldRef, newRef);
    }

    public boolean isClientActive(PlayerIdentifier player) {
        return this.skaianetData.connections.getActiveConnection(player).isPresent() || this.hasResumingClient(player);
    }

    public static void requestInfo(ServerPlayer requestingPlayer, PlayerIdentifier requestedPlayer) {
        SkaianetData.get((MinecraftServer)requestingPlayer.server).infoTracker.requestInfo(requestingPlayer, requestedPlayer);
    }
}

