/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.computer.ComputerReference;
import com.mraof.minestuck.computer.ISburbComputer;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.ClientAccess;
import com.mraof.minestuck.skaianet.ServerAccess;
import com.mraof.minestuck.skaianet.SkaianetData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class ComputerWaitingList {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<PlayerIdentifier, ComputerReference> map = new HashMap<PlayerIdentifier, ComputerReference>();
    private final SkaianetData skaianetData;
    private final Predicate<ISburbComputer> computerValidator;
    private final String name;

    ComputerWaitingList(SkaianetData skaianetData, Predicate<ISburbComputer> computerValidator, String name) {
        this.skaianetData = skaianetData;
        this.computerValidator = computerValidator;
        this.name = name;
    }

    void read(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag cmp = list.getCompound(i);
            Optional player = IdentifierHandler.load(cmp, "player").resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
            Optional computerReference = ComputerReference.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)cmp.get("computer")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
            if (player.isEmpty() || computerReference.isEmpty()) continue;
            this.map.put((PlayerIdentifier)player.get(), (ComputerReference)computerReference.get());
        }
    }

    ListTag write() {
        ListTag list = new ListTag();
        for (Map.Entry<PlayerIdentifier, ComputerReference> entry : this.map.entrySet()) {
            Optional computerTag = ComputerReference.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
            if (computerTag.isEmpty()) continue;
            CompoundTag nbt = new CompoundTag();
            nbt.put("computer", (Tag)computerTag.get());
            entry.getKey().saveToNBT(nbt, "player");
            list.add((Object)nbt);
        }
        return list;
    }

    void useAsClientAndRemoveOnSuccess(PlayerIdentifier player, Predicate<ClientAccess> consumer) {
        this.useComputerAndRemoveOnSuccess(player, clientComputer -> ClientAccess.tryGet(clientComputer).map(consumer::test).orElse(true));
    }

    void useAsServerAndRemoveOnSuccess(PlayerIdentifier player, Predicate<ServerAccess> consumer) {
        this.useComputerAndRemoveOnSuccess(player, serverComputer -> ServerAccess.tryGet(serverComputer).map(consumer::test).orElse(true));
    }

    void useComputerAndRemoveOnSuccess(PlayerIdentifier player, Predicate<ISburbComputer> computerConsumer) {
        ComputerReference reference = this.map.get(player);
        if (reference == null) {
            return;
        }
        ISburbComputer computer = reference.getComputer(this.skaianetData.mcServer);
        if (computer == null || reference.isInNether() || !computer.getOwner().equals(player) || !this.computerValidator.test(computer)) {
            LOGGER.error("{} had an invalid computer in {} waiting list", (Object)player.getUsername(), (Object)this.name);
            this.remove(player);
            return;
        }
        boolean result = computerConsumer.test(computer);
        if (result) {
            this.remove(player);
        }
    }

    void remove(PlayerIdentifier player) {
        if (this.map.remove(player) != null) {
            this.skaianetData.infoTracker.markDirty(player);
        }
    }

    void put(PlayerIdentifier player, ComputerReference reference) {
        this.map.put(player, reference);
        this.skaianetData.infoTracker.markDirty(player);
    }

    boolean contains(PlayerIdentifier player) {
        return this.map.containsKey(player);
    }

    boolean contains(ISburbComputer computer) {
        ComputerReference reference = this.map.get(computer.getOwner());
        return reference != null && reference.matches(computer);
    }

    void replace(PlayerIdentifier player, ComputerReference oldRef, ComputerReference newRef) {
        this.map.replace(player, oldRef, newRef);
    }

    Set<PlayerIdentifier> getPlayers() {
        return this.map.keySet();
    }
}

