/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.network.DataCheckerPackets;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.skaianet.DataCheckerPermission;
import com.mraof.minestuck.skaianet.PredefineData;
import com.mraof.minestuck.skaianet.SburbConnections;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.skaianet.Session;
import com.mraof.minestuck.skaianet.SessionHandler;
import com.mraof.minestuck.skaianet.SkaianetData;
import com.mraof.minestuck.world.lands.LandTypePair;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataCheckerManager {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onDataRequest(ServerPlayer player, int index) {
        if (DataCheckerPermission.hasPermission(player)) {
            CompoundTag data = DataCheckerManager.createDataTag(player.server, SessionHandler.get(player.server));
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DataCheckerPackets.Data(index, data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static CompoundTag createDataTag(MinecraftServer server, SessionHandler handler) {
        CompoundTag nbt = new CompoundTag();
        ListTag sessionList = new ListTag();
        nbt.put("sessions", (Tag)sessionList);
        for (Session session : handler.getSessions()) {
            sessionList.add((Object)DataCheckerManager.createSessionDataTag(server, session));
        }
        return nbt;
    }

    private static CompoundTag createSessionDataTag(MinecraftServer mcServer, Session session) {
        ListTag connectionList = new ListTag();
        for (PlayerIdentifier player : session.getPlayers()) {
            connectionList.add((Object)DataCheckerManager.createPlayerDataTag(player, mcServer));
        }
        CompoundTag sessionTag = new CompoundTag();
        sessionTag.put("connections", (Tag)connectionList);
        return sessionTag;
    }

    private static CompoundTag createPlayerDataTag(PlayerIdentifier player, MinecraftServer mcServer) {
        CompoundTag tag = new CompoundTag();
        tag.putString("client", player.getUsername());
        tag.putString("clientId", player.getCommandString());
        DataCheckerManager.writeConnectionData(tag, player, mcServer);
        DataCheckerManager.writeExtraData(tag, player, mcServer);
        return tag;
    }

    private static void writeConnectionData(CompoundTag tag, PlayerIdentifier player, MinecraftServer mcServer) {
        SburbConnections connections = SburbConnections.get(mcServer);
        boolean isMain = connections.hasPrimaryConnectionForClient(player);
        tag.putBoolean("isMain", isMain);
        if (isMain) {
            connections.primaryPartnerForClient(player).ifPresent(serverPlayer -> tag.putString("server", serverPlayer.getUsername()));
        } else {
            connections.getActiveConnection(player).ifPresent(connection -> tag.putString("server", connection.server().getUsername()));
        }
    }

    private static void writeExtraData(CompoundTag tag, PlayerIdentifier player, MinecraftServer mcServer) {
        SkaianetData skaianetData = SkaianetData.get(mcServer);
        SburbPlayerData playerData = skaianetData.getOrCreateData(player);
        ResourceKey<Level> landDimensionKey = playerData.getLandDimension();
        if (landDimensionKey != null) {
            DataCheckerManager.writeEntryPreparedData(tag, player, landDimensionKey, mcServer);
            return;
        }
        skaianetData.getOrCreatePredefineData(player).ifPresent(predefineData -> DataCheckerManager.putPredefinedData(tag, predefineData));
    }

    private static void writeEntryPreparedData(CompoundTag tag, PlayerIdentifier player, ResourceKey<Level> landDimensionKey, MinecraftServer mcServer) {
        tag.putString("clientDim", landDimensionKey.location().toString());
        Optional<LandTypePair.Named> landTypes = LandTypePair.getNamed(mcServer, landDimensionKey);
        landTypes.flatMap(named -> LandTypePair.Named.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, named).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(landPairTag -> tag.put("landTypes", landPairTag));
        Title.getTitle(player, mcServer).ifPresent(title -> {
            tag.putByte("class", (byte)title.heroClass().ordinal());
            tag.putByte("aspect", (byte)title.heroAspect().ordinal());
        });
    }

    private static void putPredefinedData(CompoundTag tag, PredefineData data) {
        Title title = data.getTitle();
        if (title != null) {
            tag.putByte("class", (byte)data.getTitle().heroClass().ordinal());
            tag.putByte("aspect", (byte)data.getTitle().heroAspect().ordinal());
        }
        TerrainLandType terrainType = data.getTerrainLandType();
        TitleLandType titleType = data.getTitleLandType();
        if (terrainType != null) {
            tag.putString("terrainLandType", LandTypes.TERRAIN_REGISTRY.getKey((Object)terrainType).toString());
        }
        if (titleType != null) {
            tag.putString("titleLandType", LandTypes.TITLE_REGISTRY.getKey((Object)titleType).toString());
        }
    }
}

