/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.network.DataCheckerPackets;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class DataCheckerPermission {
    private static final Set<UUID> dataCheckerPermission = new HashSet<UUID>();

    @SubscribeEvent
    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        DataCheckerPermission.sendPacket((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    private static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        dataCheckerPermission.remove(event.getEntity().getGameProfile().getId());
    }

    @SubscribeEvent
    private static void onPlayerTick(PlayerTickEvent.Post event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && DataCheckerPermission.shouldUpdateConfigurations(player = (ServerPlayer)player2)) {
            DataCheckerPermission.sendPacket(player);
        }
    }

    @SubscribeEvent
    private static void serverStopped(ServerStoppedEvent event) {
        dataCheckerPermission.clear();
    }

    private static boolean shouldUpdateConfigurations(ServerPlayer player) {
        boolean permission = DataCheckerPermission.hasPermission(player);
        return permission != dataCheckerPermission.contains(player.getGameProfile().getId());
    }

    private static void sendPacket(ServerPlayer player) {
        boolean permission = DataCheckerPermission.hasPermission(player);
        if (permission) {
            dataCheckerPermission.add(player.getGameProfile().getId());
        } else {
            dataCheckerPermission.remove(player.getGameProfile().getId());
        }
        DataCheckerPackets.Permission packet = new DataCheckerPackets.Permission(permission);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static boolean hasPermission(ServerPlayer player) {
        return switch ((MinestuckConfig.PermissionType)((Object)MinestuckConfig.SERVER.dataCheckerPermission.get())) {
            default -> throw new MatchException(null, null);
            case MinestuckConfig.PermissionType.ANYONE -> true;
            case MinestuckConfig.PermissionType.OPS -> DataCheckerPermission.hasOp(player);
            case MinestuckConfig.PermissionType.GAMEMODE -> DataCheckerPermission.hasGamemodePermission(player);
            case MinestuckConfig.PermissionType.OPS_OR_GAMEMODE -> {
                if (DataCheckerPermission.hasOp(player) || DataCheckerPermission.hasGamemodePermission(player)) {
                    yield true;
                }
                yield false;
            }
            case MinestuckConfig.PermissionType.NONE -> false;
        };
    }

    private static boolean hasGamemodePermission(ServerPlayer player) {
        GameType gameType = player.gameMode.getGameModeForPlayer();
        EditData data = ServerEditHandler.getData((Player)player);
        if (data != null) {
            gameType = data.getDecoy().gameType;
        }
        return !gameType.isSurvival();
    }

    private static boolean hasOp(ServerPlayer player) {
        MinecraftServer server = player.getServer();
        if (server != null && server.getPlayerList().isOp(player.getGameProfile())) {
            return player.hasPermissions(2);
        }
        return false;
    }
}

