/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.EnumClass;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.skaianet.SkaianetData;
import com.mraof.minestuck.world.lands.LandTypePair;
import com.mraof.minestuck.world.lands.gen.LandTypeGenerator;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

class Generator {
    Generator() {
    }

    static Title generateTitle(PlayerIdentifier player, Set<EnumAspect> availableAspects, SkaianetData skaianetData) {
        Random random = new Random();
        Set<Title> usedTitles = Generator.titlesUsedBy(skaianetData.sessionHandler.playersToCheckForDataSelection(player).toList(), skaianetData);
        List<EnumAspect> unusedAspects = Generator.unusedAspects(availableAspects, usedTitles);
        List<EnumClass> unusedClasses = Generator.unusedClasses(usedTitles);
        if (!unusedAspects.isEmpty() && !unusedClasses.isEmpty()) {
            EnumAspect a2 = Generator.getRandomFromList(unusedAspects, random);
            EnumClass c = Generator.getRandomFromList(unusedClasses, random);
            return new Title(c, a2);
        }
        if (!unusedAspects.isEmpty()) {
            EnumAspect a3 = Generator.getRandomFromList(unusedAspects, random);
            EnumClass c = Generator.getRandomFromList(EnumClass.valuesStream().toList(), random);
            return new Title(c, a3);
        }
        if (!unusedClasses.isEmpty()) {
            EnumAspect a4 = Generator.getRandomFromList(List.copyOf(availableAspects), random);
            EnumClass c = Generator.getRandomFromList(unusedClasses, random);
            return new Title(c, a4);
        }
        List<Title> unusedTitles = availableAspects.stream().flatMap(a -> EnumClass.valuesStream().map(c -> new Title((EnumClass)((Object)((Object)c)), (EnumAspect)((Object)a)))).filter(title -> !usedTitles.contains(title)).toList();
        if (!unusedTitles.isEmpty()) {
            return Generator.getRandomFromList(unusedTitles, random);
        }
        EnumAspect a5 = Generator.getRandomFromList(List.copyOf(availableAspects), random);
        EnumClass c = Generator.getRandomFromList(EnumClass.valuesStream().toList(), random);
        return new Title(c, a5);
    }

    static Set<Title> titlesUsedBy(Collection<PlayerIdentifier> players, SkaianetData skaianetData) {
        return players.stream().flatMap(player -> Generator.titleForPlayer(player, skaianetData).stream()).collect(Collectors.toSet());
    }

    @NotNull
    private static Optional<Title> titleForPlayer(PlayerIdentifier player, SkaianetData skaianetData) {
        return Title.getTitle(player, skaianetData.mcServer).or(() -> skaianetData.getOrCreatePredefineData(player).flatMap(data -> Optional.ofNullable(data.getTitle())));
    }

    private static List<EnumAspect> unusedAspects(Set<EnumAspect> base, Set<Title> usedTitles) {
        Set usedAspects = usedTitles.stream().map(Title::heroAspect).collect(Collectors.toSet());
        return base.stream().filter(a -> !usedAspects.contains(a)).collect(Collectors.toList());
    }

    private static List<EnumClass> unusedClasses(Set<Title> usedTitles) {
        Set usedClasses = usedTitles.stream().map(Title::heroClass).collect(Collectors.toSet());
        return EnumClass.valuesStream().filter(c -> !usedClasses.contains(c)).collect(Collectors.toList());
    }

    static TitleLandType generateWeightedTitleLandType(Collection<PlayerIdentifier> otherPlayers, EnumAspect aspect, @Nullable TerrainLandType terrainType, SkaianetData skaianetData) {
        Random random = new Random();
        LandTypeGenerator landGen = new LandTypeGenerator(random.nextLong());
        List<TitleLandType> usedTypes = Generator.titleLandTypesUsedBy(otherPlayers, skaianetData);
        return landGen.getTitleAspect(terrainType, aspect, usedTypes);
    }

    static List<TitleLandType> titleLandTypesUsedBy(Collection<PlayerIdentifier> players, SkaianetData skaianetData) {
        return players.stream().flatMap(player -> Generator.titleLandTypeForPlayer(player, skaianetData).stream()).toList();
    }

    private static Optional<TitleLandType> titleLandTypeForPlayer(PlayerIdentifier player, SkaianetData skaianetData) {
        return LandTypePair.getTypes(skaianetData.mcServer, skaianetData.getOrCreateData(player).getLandDimension()).map(LandTypePair::getTitle).or(() -> skaianetData.getOrCreatePredefineData(player).flatMap(data -> Optional.ofNullable(data.getTitleLandType())));
    }

    static TerrainLandType generateWeightedTerrainLandType(Collection<PlayerIdentifier> otherPlayers, TitleLandType titleType, SkaianetData skaianetData) {
        Random random = new Random();
        LandTypeGenerator landGen = new LandTypeGenerator(random.nextLong());
        List<TerrainLandType> usedTypes = Generator.terrainLandTypesUsedBy(otherPlayers, skaianetData);
        return landGen.getTerrainAspect(titleType, usedTypes);
    }

    private static List<TerrainLandType> terrainLandTypesUsedBy(Collection<PlayerIdentifier> players, SkaianetData skaianetData) {
        return players.stream().flatMap(player -> Generator.terrainLandTypeForPlayer(player, skaianetData).stream()).toList();
    }

    private static Optional<TerrainLandType> terrainLandTypeForPlayer(PlayerIdentifier player, SkaianetData skaianetData) {
        return LandTypePair.getTypes(skaianetData.mcServer, skaianetData.getOrCreateData(player).getLandDimension()).map(LandTypePair::getTerrain).or(() -> skaianetData.getOrCreatePredefineData(player).flatMap(data -> Optional.ofNullable(data.getTerrainLandType())));
    }

    private static <T> T getRandomFromList(List<T> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }
}

