/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.network.computer.SkaianetInfoPackets;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.ActiveConnection;
import com.mraof.minestuck.skaianet.LandChain;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.skaianet.SkaianetData;
import com.mraof.minestuck.skaianet.client.ReducedConnection;
import com.mraof.minestuck.skaianet.client.ReducedPlayerState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck")
public final class InfoTracker {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String PRIVATE_COMPUTER = "minestuck.private_computer";
    private final SkaianetData skaianet;
    private final Map<PlayerIdentifier, Set<PlayerIdentifier>> listenerMap = new HashMap<PlayerIdentifier, Set<PlayerIdentifier>>();
    private final Set<PlayerIdentifier> toUpdate = new HashSet<PlayerIdentifier>();
    private final Map<PlayerIdentifier, Set<Integer>> openedServersCache = new HashMap<PlayerIdentifier, Set<Integer>>();
    private boolean resendLandChains;

    InfoTracker(SkaianetData skaianet) {
        this.skaianet = skaianet;
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SkaianetData.get((MinecraftServer)player2.server).infoTracker.onPlayerLoggedIn(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerIdentifier identifier = Objects.requireNonNull(IdentifierHandler.encode((Player)player2));
            SkaianetData.get((MinecraftServer)player2.server).infoTracker.listenerMap.values().forEach(set -> set.removeIf(identifier::equals));
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        SkaianetData.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).infoTracker.checkAndSend();
    }

    private void onPlayerLoggedIn(ServerPlayer player) {
        PlayerIdentifier identifier = IdentifierHandler.encode((Player)player);
        this.getSet(identifier).add(identifier);
        this.sendConnectionInfo(identifier);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.createLandChainPacket(), (CustomPacketPayload[])new CustomPacketPayload[]{new SkaianetInfoPackets.HasEntered(SburbPlayerData.get(player).hasEntered())});
    }

    private Set<PlayerIdentifier> getSet(PlayerIdentifier identifier) {
        return this.listenerMap.computeIfAbsent(identifier, ignored -> new HashSet());
    }

    void requestInfo(ServerPlayer player, PlayerIdentifier p1) {
        PlayerIdentifier p0 = IdentifierHandler.encode((Player)player);
        if (p0 == null) {
            return;
        }
        if (this.cannotAccess(player, p1)) {
            player.sendSystemMessage((Component)Component.literal((String)"[Minestuck] ").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)PRIVATE_COMPUTER)));
            return;
        }
        if (!this.getSet(p1).add(p0)) {
            LOGGER.warn("[Skaianet] Player {} already got the requested data.", (Object)player.getName());
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.generateClientInfoPacket(p1), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private SkaianetInfoPackets.LandChains createLandChainPacket() {
        return new SkaianetInfoPackets.LandChains(this.createLandChains());
    }

    private List<LandChain> createLandChains() {
        ArrayList<LandChain> landChains = new ArrayList<LandChain>();
        HashSet checked = new HashSet();
        this.skaianet.players().forEach(player -> this.makeLandChain(checked, (PlayerIdentifier)player).ifPresent(landChains::add));
        return landChains;
    }

    private Optional<LandChain> makeLandChain(Set<ResourceKey<Level>> checked, PlayerIdentifier player) {
        PlayerIdentifier nextPlayer;
        ResourceKey<Level> nextLand;
        ResourceKey<Level> dimensionType = this.skaianet.getOrCreateData(player).getLandDimensionIfEntered();
        if (dimensionType == null || !checked.add(dimensionType)) {
            return Optional.empty();
        }
        LinkedList<ResourceKey<Level>> chain = new LinkedList<ResourceKey<Level>>();
        chain.add(dimensionType);
        Iterator<PlayerIdentifier> iterator = this.skaianet.connections.iterateServerPartners(player).iterator();
        while (iterator.hasNext() && (nextLand = this.skaianet.getOrCreateData(nextPlayer = iterator.next()).getLandDimensionIfEntered()) != null) {
            if (!checked.add(nextLand)) {
                return Optional.of(new LandChain(chain, true));
            }
            chain.addLast(nextLand);
        }
        iterator = this.skaianet.connections.iterateClientPartners(player).iterator();
        while (iterator.hasNext() && (nextLand = this.skaianet.getOrCreateData(nextPlayer = iterator.next()).getLandDimensionIfEntered()) != null && checked.add(nextLand)) {
            chain.addFirst(nextLand);
        }
        return Optional.of(new LandChain(chain, false));
    }

    void markLandChainDirty() {
        this.resendLandChains = true;
    }

    void markDirty(PlayerIdentifier player) {
        this.toUpdate.add(player);
    }

    void markDirty(ActiveConnection connection) {
        this.markDirty(connection.client());
        this.markDirty(connection.server());
    }

    private void checkAndSend() {
        this.checkListeners();
        for (Map.Entry<PlayerIdentifier, Set<Integer>> entry : this.openedServersCache.entrySet()) {
            if (entry.getValue().equals(this.skaianet.sessionHandler.getServerList(entry.getKey()).keySet())) continue;
            this.markDirty(entry.getKey());
        }
        if (!this.toUpdate.isEmpty()) {
            this.toUpdate.forEach(this::sendConnectionInfo);
            this.toUpdate.clear();
        }
        if (this.resendLandChains) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)this.createLandChainPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.resendLandChains = false;
        }
    }

    private void sendConnectionInfo(PlayerIdentifier player) {
        SkaianetInfoPackets.Data packet = this.generateClientInfoPacket(player);
        for (PlayerIdentifier listener : this.getSet(player)) {
            ServerPlayer playerListener = listener.getPlayer(this.skaianet.mcServer);
            if (playerListener == null) continue;
            if (player.equals(listener) && this.skaianet.connections.activeConnections().anyMatch(c -> c.hasPlayer(player))) {
                MSCriteriaTriggers.SBURB_CONNECTION.get().trigger(playerListener);
            }
            PacketDistributor.sendToPlayer((ServerPlayer)playerListener, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private SkaianetInfoPackets.Data generateClientInfoPacket(PlayerIdentifier player) {
        boolean clientResuming = this.skaianet.computerInteractions.hasResumingClient(player);
        boolean serverResuming = this.skaianet.computerInteractions.hasResumingServer(player);
        boolean hasPrimaryConnectionAsClient = this.skaianet.connections.hasPrimaryConnectionForClient(player);
        boolean hasPrimaryConnectionAsServer = this.skaianet.connections.hasPrimaryConnectionForServer(player);
        Map<Integer, String> serverMap = this.skaianet.sessionHandler.getServerList(player);
        this.openedServersCache.put(player, serverMap.keySet());
        ReducedPlayerState playerState = new ReducedPlayerState(clientResuming, serverResuming, hasPrimaryConnectionAsClient, hasPrimaryConnectionAsServer, serverMap);
        List<ReducedConnection> list = this.skaianet.connections.activeConnections().filter(c -> c.hasPlayer(player)).map(ReducedConnection::new).toList();
        return new SkaianetInfoPackets.Data(player.getId(), playerState, list);
    }

    private void checkListeners() {
        this.listenerMap.forEach((identifier, set) -> set.removeIf(listener -> this.cannotAccess(listener.getPlayer(this.skaianet.mcServer), (PlayerIdentifier)identifier)));
    }

    private boolean cannotAccess(ServerPlayer listener, PlayerIdentifier identifier) {
        return listener == null || (Boolean)MinestuckConfig.SERVER.privateComputers.get() != false && !identifier.appliesTo((Player)listener) && !listener.hasPermissions(2);
    }
}

