/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public record LandChain(List<ResourceKey<Level>> lands, boolean isLoop) {
    public static final StreamCodec<RegistryFriendlyByteBuf, LandChain> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION).apply(ByteBufCodecs.list()), LandChain::lands, (StreamCodec)ByteBufCodecs.BOOL, LandChain::isLoop, LandChain::new);

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isLoop);
        buffer.writeCollection(this.lands, FriendlyByteBuf::writeResourceKey);
    }

    public static LandChain read(FriendlyByteBuf buffer) {
        boolean isLoop = buffer.readBoolean();
        List lands = buffer.readList(buffer1 -> buffer1.readResourceKey(Registries.DIMENSION));
        return new LandChain(lands, isLoop);
    }

    public Stream<AngledLand> relativeAngledLands(ResourceKey<Level> sourceLand) {
        int positions = this.lands().size() + (this.isLoop() ? 0 : 1);
        int sourceIndex = this.lands().indexOf(sourceLand);
        float sourceAngle = (float)Math.PI * 2 * (float)sourceIndex / (float)positions;
        return IntStream.range(0, this.lands().size()).mapToObj(landIndex -> new AngledLand(this.lands().get(landIndex), LandChain.angleBetween(sourceAngle, (float)Math.PI * 2 * (float)landIndex / (float)positions)));
    }

    private static float angleBetween(float fromAngle, float toAngle) {
        float angle = toAngle - fromAngle;
        if (angle < 0.0f) {
            return angle + (float)Math.PI * 2;
        }
        return angle;
    }

    public record AngledLand(ResourceKey<Level> landId, float landToLandAngle) {
        public boolean isZeroAngle() {
            return this.landToLandAngle == 0.0f;
        }

        public boolean isOppositeAngle() {
            return this.landToLandAngle == (float)Math.PI;
        }

        public float skaiaToLandAngle() {
            return ((float)Math.PI - this.landToLandAngle) / 2.0f;
        }
    }
}

