/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.skaianet.Generator;
import com.mraof.minestuck.skaianet.SkaianetData;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.gen.LandTypeSelection;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class PredefineData {
    public static final String TITLE_ALREADY_SET = "minestuck.predefine.title_already_set";
    public static final String RESETTING_TERRAIN_TYPE = "minestuck.predefine.resetting_terrain_type";
    public static final String GENERATED_TITLE = "minestuck.predefine.generated_title";
    public static final String CHANGED_TITLE = "minestuck.predefine.changed_title";
    public static final String GENERATED_TITLE_LAND = "minestuck.predefine.generated_title_land";
    public static final String CHANGED_TITLE_LAND = "minestuck.predefine.changed_title_land";
    private final PlayerIdentifier player;
    private Title title;
    private TerrainLandType terrainLandType;
    private TitleLandType titleLandType;

    PredefineData(PlayerIdentifier player) {
        this.player = player;
    }

    PredefineData read(CompoundTag nbt) {
        this.title = Title.tryRead(nbt, "title");
        if (nbt.contains("landTerrain", 8)) {
            this.terrainLandType = (TerrainLandType)LandTypes.TERRAIN_REGISTRY.get(ResourceLocation.tryParse((String)nbt.getString("landTerrain")));
        }
        if (nbt.contains("landTitle", 8)) {
            this.titleLandType = (TitleLandType)LandTypes.TITLE_REGISTRY.get(ResourceLocation.tryParse((String)nbt.getString("landTitle")));
        }
        return this;
    }

    CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        if (this.title != null) {
            this.title.write(nbt, "title");
        }
        if (this.terrainLandType != null) {
            nbt.putString("landTerrain", LandTypes.TERRAIN_REGISTRY.getKey((Object)this.terrainLandType).toString());
        }
        if (this.titleLandType != null) {
            nbt.putString("landTitle", LandTypes.TITLE_REGISTRY.getKey((Object)this.titleLandType).toString());
        }
        return nbt;
    }

    public void predefineTitle(@Nonnull Title title) {
        this.title = title;
    }

    public void predefineTerrainLand(TerrainLandType landType, CommandSourceStack source) {
        this.forceVerifyTitleLand(landType, source);
        this.terrainLandType = landType;
    }

    public void predefineTitleLand(TitleLandType landType, CommandSourceStack source) {
        this.forceVerifyTitle(Collections.singleton(landType), source);
        if (this.terrainLandType != null && !landType.isAspectCompatible(this.terrainLandType)) {
            source.sendSuccess(() -> Component.translatable((String)RESETTING_TERRAIN_TYPE, (Object[])new Object[]{LandTypes.TERRAIN_REGISTRY.getKey((Object)this.terrainLandType).toString()}).withStyle(ChatFormatting.YELLOW), true);
            this.terrainLandType = null;
        }
        this.titleLandType = landType;
    }

    private void forceVerifyTitle(Set<TitleLandType> availableTypes, CommandSourceStack source) {
        Set<EnumAspect> availableAspects = availableTypes.stream().flatMap(titleType -> LandTypeSelection.compatibleAspects(titleType).stream()).collect(Collectors.toSet());
        if (this.title == null || !availableAspects.contains((Object)this.title.heroAspect())) {
            Title previous = this.title;
            this.title = Generator.generateTitle(this.player, availableAspects, SkaianetData.get(source.getServer()));
            if (!availableAspects.contains((Object)this.title.heroAspect())) {
                this.terrainLandType = null;
                this.titleLandType = null;
                throw new IllegalStateException("Generated title did not meet requirements!");
            }
            if (previous == null) {
                source.sendSuccess(() -> Component.translatable((String)GENERATED_TITLE, (Object[])new Object[]{this.title.asTextComponent()}), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)CHANGED_TITLE, (Object[])new Object[]{previous.asTextComponent(), this.title.asTextComponent()}).withStyle(ChatFormatting.YELLOW), true);
            }
        }
    }

    private void forceVerifyTitleLand(TerrainLandType type, CommandSourceStack source) {
        if (this.titleLandType == null || !this.titleLandType.isAspectCompatible(type)) {
            Set<TitleLandType> availableTypes = LandTypeSelection.compatibleTitleTypes(type);
            this.forceVerifyTitle(availableTypes, source);
            availableTypes = LandTypeSelection.compatibleTitleTypes(type, this.title.heroAspect());
            if (availableTypes.isEmpty()) {
                this.terrainLandType = null;
                this.titleLandType = null;
                throw new IllegalStateException("Had no title land types to generate when some were expected.");
            }
            SkaianetData skaianetData = SkaianetData.get(source.getServer());
            TitleLandType previous = this.titleLandType;
            List<PlayerIdentifier> otherPlayers = skaianetData.sessionHandler.playersToCheckForDataSelection(this.player).toList();
            this.titleLandType = Generator.generateWeightedTitleLandType(otherPlayers, this.title.heroAspect(), type, skaianetData);
            if (!this.titleLandType.isAspectCompatible(type)) {
                this.terrainLandType = null;
                throw new IllegalStateException("Generated title land type did not meet requirements!");
            }
            if (previous == null) {
                source.sendSuccess(() -> Component.translatable((String)GENERATED_TITLE_LAND, (Object[])new Object[]{LandTypes.TITLE_REGISTRY.getKey((Object)this.titleLandType).toString()}), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)CHANGED_TITLE_LAND, (Object[])new Object[]{LandTypes.TITLE_REGISTRY.getKey((Object)previous).toString(), LandTypes.TITLE_REGISTRY.getKey((Object)this.titleLandType).toString()}).withStyle(ChatFormatting.YELLOW), true);
            }
        }
    }

    public PlayerIdentifier getPlayer() {
        return this.player;
    }

    public Title getTitle() {
        return this.title;
    }

    public TerrainLandType getTerrainLandType() {
        return this.terrainLandType;
    }

    public TitleLandType getTitleLandType() {
        return this.titleLandType;
    }
}

