/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.google.common.collect.AbstractIterator;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.computer.ComputerReference;
import com.mraof.minestuck.computer.ISburbComputer;
import com.mraof.minestuck.computer.SburbClientData;
import com.mraof.minestuck.event.SburbEvent;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.ActiveConnection;
import com.mraof.minestuck.skaianet.ClientAccess;
import com.mraof.minestuck.skaianet.ServerAccess;
import com.mraof.minestuck.skaianet.SkaianetData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SburbConnections {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CLOSED = "minestuck.closed_message";
    private final SkaianetData skaianetData;
    private final List<ActiveConnection> activeConnections = new ArrayList<ActiveConnection>();
    private final Map<PlayerIdentifier, Optional<PlayerIdentifier>> primaryClientToServerMap = new HashMap<PlayerIdentifier, Optional<PlayerIdentifier>>();

    SburbConnections(SkaianetData skaianetData) {
        this.skaianetData = skaianetData;
    }

    SburbConnections(SkaianetData skaianetData, CompoundTag tag) {
        this(skaianetData);
        ListTag activeConnectionList = tag.getList("connections", 10);
        for (int i = 0; i < activeConnectionList.size(); ++i) {
            ActiveConnection.read(activeConnectionList.getCompound(i)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.activeConnections::add);
        }
        ListTag primaryConnectionList = tag.getList("primary_connections", 10);
        for (int i = 0; i < primaryConnectionList.size(); ++i) {
            CompoundTag connectionTag = primaryConnectionList.getCompound(i);
            Optional client = IdentifierHandler.load(connectionTag, "client").resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
            if (client.isEmpty()) {
                LOGGER.error("Unable to load client id for primary connection from data: {}", (Object)connectionTag);
                continue;
            }
            Optional server = IdentifierHandler.loadOptional(connectionTag, "server").resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).flatMap(Function.identity());
            this.primaryClientToServerMap.put((PlayerIdentifier)client.get(), server);
        }
    }

    void write(CompoundTag tag) {
        ListTag activeConnectionList = new ListTag();
        for (ActiveConnection connection : this.activeConnections) {
            activeConnectionList.add((Object)connection.write());
        }
        tag.put("connections", (Tag)activeConnectionList);
        ListTag primaryConnectionList = new ListTag();
        for (Map.Entry<PlayerIdentifier, Optional<PlayerIdentifier>> entry : this.primaryClientToServerMap.entrySet()) {
            CompoundTag connectionTag = new CompoundTag();
            entry.getKey().saveToNBT(connectionTag, "client");
            entry.getValue().ifPresent(server -> server.saveToNBT(connectionTag, "server"));
            primaryConnectionList.add((Object)connectionTag);
        }
        tag.put("primary_connections", (Tag)primaryConnectionList);
    }

    void readOldConnectionData(CompoundTag connectionTag, Consumer<PlayerIdentifier> playerConsumer) {
        boolean isMain = connectionTag.getBoolean("IsMain");
        boolean active = !isMain || connectionTag.getBoolean("IsActive");
        Optional client = IdentifierHandler.load(connectionTag, "client").resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
        client.ifPresent(playerConsumer);
        if (client.isEmpty()) {
            LOGGER.error("Unable to load client id for old connection from data: {}", (Object)connectionTag);
            return;
        }
        Optional server = IdentifierHandler.loadNullable(connectionTag, "server").resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).flatMap(Function.identity());
        server.ifPresent(playerConsumer);
        if (active && server.isPresent()) {
            DataResult.unbox((App)DataResult.instance().apply2((clientComputer, serverComputer) -> new ActiveConnection((PlayerIdentifier)client.get(), (ComputerReference)clientComputer, (PlayerIdentifier)server.get(), (ComputerReference)serverComputer), (App)ComputerReference.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)connectionTag.getCompound("client_computer")), (App)ComputerReference.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)connectionTag.getCompound("server_computer")))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.activeConnections::add);
        }
        if (isMain) {
            this.primaryClientToServerMap.put((PlayerIdentifier)client.get(), server);
        }
        LOGGER.debug("Parsed old connection between {} and {}", client.get(), server);
    }

    public static SburbConnections get(MinecraftServer mcServer) {
        return SkaianetData.get((MinecraftServer)mcServer).connections;
    }

    Optional<ISburbComputer> clientComputerIfValid(ActiveConnection connection) {
        return Optional.ofNullable(connection.clientComputer().getComputer(this.skaianetData.mcServer)).filter(computer -> connection.client().equals(computer.getOwner()) && computer.getSburbClientData().map(SburbClientData::isConnectedToServer).orElse(false) != false);
    }

    Optional<ISburbComputer> serverComputerIfValid(ActiveConnection connection) {
        return Optional.ofNullable(connection.serverComputer().getComputer(this.skaianetData.mcServer)).filter(computer -> connection.server().equals(computer.getOwner()));
    }

    public Optional<ActiveConnection> getCheckedActiveConnection(PlayerIdentifier client) {
        return this.getActiveConnection(client).flatMap(connection -> {
            Optional<ISburbComputer> cc = this.clientComputerIfValid((ActiveConnection)connection);
            Optional<ISburbComputer> sc = this.serverComputerIfValid((ActiveConnection)connection);
            if (cc.isEmpty() || sc.isEmpty()) {
                this.closeConnection((ActiveConnection)connection, cc.orElse(null), sc.orElse(null));
                return Optional.empty();
            }
            return Optional.of(connection);
        });
    }

    public Optional<ActiveConnection> getActiveConnection(PlayerIdentifier client) {
        return this.activeConnections().filter(c -> c.client().equals(client)).findAny();
    }

    public Optional<ActiveConnection> getServerConnection(ISburbComputer computer) {
        return this.activeConnections().filter(c -> c.isServer(computer)).findAny();
    }

    public Optional<ActiveConnection> getClientConnection(ISburbComputer computer) {
        return this.activeConnections().filter(c -> c.isClient(computer)).findAny();
    }

    public Stream<ActiveConnection> activeConnections() {
        return this.activeConnections.stream();
    }

    public boolean hasPrimaryConnectionForClient(PlayerIdentifier player) {
        return this.primaryClientToServerMap.containsKey(player);
    }

    public Optional<PlayerIdentifier> primaryPartnerForClient(PlayerIdentifier player) {
        return Objects.requireNonNullElse(this.primaryClientToServerMap.get(player), Optional.empty());
    }

    public boolean hasPrimaryConnectionForServer(PlayerIdentifier player) {
        return this.primaryClientToServerMap.containsValue(Optional.of(player));
    }

    public Optional<PlayerIdentifier> primaryPartnerForServer(PlayerIdentifier player) {
        return this.primaryClientToServerMap.entrySet().stream().filter(entry -> Optional.of(player).equals(entry.getValue())).findAny().map(Map.Entry::getKey);
    }

    public boolean isPrimaryPair(PlayerIdentifier client, PlayerIdentifier server) {
        return this.primaryPartnerForClient(client).map(server::equals).orElse(false);
    }

    public boolean canMakeNewRegularConnectionAsServer(PlayerIdentifier serverPlayer) {
        return !this.hasPrimaryConnectionForServer(serverPlayer) && this.activeConnections().filter(connection -> connection.server().equals(serverPlayer)).allMatch(connection -> this.hasPrimaryConnectionForClient(connection.client()));
    }

    boolean canMakeSecondaryConnection(PlayerIdentifier client, PlayerIdentifier server) {
        return (Boolean)MinestuckConfig.SERVER.allowSecondaryConnections.get() != false && this.primaryPartnerForClient(client).isPresent() && this.skaianetData.sessionHandler.isInSameSession(client, server);
    }

    boolean tryConnect(ClientAccess client, ServerAccess server) {
        PlayerIdentifier clientPlayer = client.computer().getOwner();
        PlayerIdentifier serverPlayer = server.computer().getOwner();
        if (this.getActiveConnection(clientPlayer).isPresent()) {
            return false;
        }
        if (!this.hasPrimaryConnectionForClient(clientPlayer)) {
            if (!this.canMakeNewRegularConnectionAsServer(serverPlayer)) {
                return false;
            }
            this.newActiveConnection(client, server, SburbEvent.ConnectionType.REGULAR);
            return true;
        }
        Optional<PlayerIdentifier> primaryServer = this.primaryPartnerForClient(clientPlayer);
        if (primaryServer.isEmpty()) {
            if (!this.canMakeNewRegularConnectionAsServer(serverPlayer)) {
                return false;
            }
            this.setPrimaryConnection(clientPlayer, serverPlayer);
            this.newActiveConnection(client, server, SburbEvent.ConnectionType.NEW_SERVER);
            return true;
        }
        if (primaryServer.get().equals(serverPlayer)) {
            this.newActiveConnection(client, server, SburbEvent.ConnectionType.RESUME);
            return true;
        }
        if (this.canMakeSecondaryConnection(clientPlayer, serverPlayer)) {
            this.newActiveConnection(client, server, SburbEvent.ConnectionType.SECONDARY);
            return true;
        }
        return false;
    }

    private void newActiveConnection(ClientAccess client, ServerAccess server, SburbEvent.ConnectionType type) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(server);
        if (this.getActiveConnection(client.computer().getOwner()).isPresent()) {
            throw new IllegalStateException("Should not activate sburb connection when already active");
        }
        ActiveConnection activeConnection = new ActiveConnection(client.computer(), server.computer());
        this.activeConnections.add(activeConnection);
        this.skaianetData.sessionHandler.onConnect(activeConnection.client(), activeConnection.server());
        this.skaianetData.infoTracker.markDirty(activeConnection);
        client.data().setIsResuming(false);
        client.data().setIsConnectedToServer(true);
        server.data().setIsOpen(false);
        NeoForge.EVENT_BUS.post((Event)new SburbEvent.ConnectionCreated(this.skaianetData.mcServer, activeConnection, type));
    }

    private void closeConnectionIf(Predicate<ActiveConnection> predicate) {
        this.activeConnections().filter(predicate).toList().forEach(this::closeConnection);
    }

    public void closeConnection(ActiveConnection connection) {
        this.closeConnection(connection, null, null);
    }

    void closeConnection(ActiveConnection connection, @Nullable ISburbComputer clientComputer, @Nullable ISburbComputer serverComputer) {
        if (clientComputer == null) {
            clientComputer = this.clientComputerIfValid(connection).orElse(null);
        }
        if (serverComputer == null) {
            serverComputer = this.serverComputerIfValid(connection).orElse(null);
        }
        this.activeConnections.remove(connection);
        this.skaianetData.sessionHandler.onDisconnect(connection.client(), connection.server());
        this.skaianetData.infoTracker.markDirty(connection);
        if (clientComputer != null) {
            clientComputer.getSburbClientData().ifPresent(sburbClientData -> {
                sburbClientData.setIsConnectedToServer(false);
                sburbClientData.setEventMessage(CLOSED);
            });
        }
        if (serverComputer != null) {
            serverComputer.getSburbServerData().ifPresent(sburbServerData -> {
                sburbServerData.setIsConnected();
                sburbServerData.setEventMessage(CLOSED);
            });
        }
        NeoForge.EVENT_BUS.post((Event)new SburbEvent.ConnectionClosed(this.skaianetData.mcServer, connection));
    }

    public void setPrimaryConnection(ActiveConnection connection) {
        this.setPrimaryConnection(connection.client(), connection.server());
    }

    public void setPrimaryConnection(PlayerIdentifier client, PlayerIdentifier server) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(server);
        if (this.isPrimaryPair(client, server)) {
            return;
        }
        if (this.primaryPartnerForClient(client).isPresent()) {
            throw new IllegalStateException("Client player " + client.getUsername() + " already has a primary partner");
        }
        if (this.hasPrimaryConnectionForServer(server)) {
            throw new IllegalStateException("Server player " + server.getUsername() + " already has a primary partner");
        }
        this.closeConnectionIf(connection -> !connection.client().equals(client) && connection.server().equals(server) && !this.hasPrimaryConnectionForClient(connection.client()));
        LOGGER.debug("Connecting players {} and {}", (Object)client, (Object)server);
        this.primaryClientToServerMap.put(client, Optional.of(server));
        this.skaianetData.sessionHandler.onConnect(client, server);
        this.skaianetData.infoTracker.markDirty(client);
        this.skaianetData.infoTracker.markDirty(server);
        if (this.skaianetData.getOrCreateData(client).hasEntered()) {
            this.skaianetData.infoTracker.markLandChainDirty();
        }
    }

    public void unlinkClientPlayer(PlayerIdentifier clientPlayer) {
        this.getActiveConnection(clientPlayer).ifPresent(this::closeConnection);
        if (!this.primaryClientToServerMap.containsKey(clientPlayer)) {
            return;
        }
        Optional<PlayerIdentifier> oldServerPlayer = this.primaryClientToServerMap.get(clientPlayer);
        if (oldServerPlayer.isEmpty()) {
            return;
        }
        LOGGER.debug("Disconnecting server {} from client {}", (Object)oldServerPlayer.get(), (Object)clientPlayer);
        this.primaryClientToServerMap.put(clientPlayer, Optional.empty());
        this.skaianetData.sessionHandler.onDisconnect(clientPlayer, oldServerPlayer.get());
        this.skaianetData.infoTracker.markDirty(oldServerPlayer.get());
        if (this.skaianetData.getOrCreateData(clientPlayer).hasEntered()) {
            this.skaianetData.infoTracker.markLandChainDirty();
        }
    }

    public void unlinkServerPlayer(PlayerIdentifier serverPlayer) {
        this.primaryPartnerForServer(serverPlayer).ifPresent(this::unlinkClientPlayer);
        this.closeConnectionIf(connection -> connection.server().equals(serverPlayer) && !this.hasPrimaryConnectionForClient(connection.client()));
    }

    public void setPrimaryConnectionForEntry(PlayerIdentifier player) {
        if (this.hasPrimaryConnectionForClient(player)) {
            return;
        }
        Optional<ActiveConnection> connection = this.getActiveConnection(player);
        if (connection.isPresent()) {
            this.setPrimaryConnection(connection.get());
        } else {
            LOGGER.info("Player {} entered without connection.", (Object)player.getUsername());
            this.primaryClientToServerMap.put(player, Optional.empty());
            this.skaianetData.infoTracker.markDirty(player);
        }
    }

    public Iterable<PlayerIdentifier> iterateClientPartners(final PlayerIdentifier player) {
        return () -> new AbstractIterator<PlayerIdentifier>(){
            private PlayerIdentifier serverPlayer;
            {
                this.serverPlayer = player;
            }

            @Nullable
            protected PlayerIdentifier computeNext() {
                Optional<PlayerIdentifier> clientPlayer = SburbConnections.this.primaryPartnerForServer(this.serverPlayer);
                if (clientPlayer.isEmpty()) {
                    return (PlayerIdentifier)this.endOfData();
                }
                this.serverPlayer = clientPlayer.get();
                return clientPlayer.get();
            }
        };
    }

    public Iterable<PlayerIdentifier> iterateServerPartners(final PlayerIdentifier player) {
        return () -> new AbstractIterator<PlayerIdentifier>(){
            private PlayerIdentifier clientPlayer;
            {
                this.clientPlayer = player;
            }

            @Nullable
            protected PlayerIdentifier computeNext() {
                Optional<PlayerIdentifier> serverPlayer = SburbConnections.this.primaryPartnerForClient(this.clientPlayer);
                if (serverPlayer.isEmpty()) {
                    return (PlayerIdentifier)this.endOfData();
                }
                this.clientPlayer = serverPlayer.get();
                return serverPlayer.get();
            }
        };
    }
}

