/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.computer.editmode.DeployEntry;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.network.computer.SkaianetInfoPackets;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.SburbHandler;
import com.mraof.minestuck.skaianet.SkaianetData;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SburbPlayerData {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PlayerIdentifier playerId;
    private final MinecraftServer mcServer;
    private boolean hasEntered = false;
    @Nullable
    private ResourceKey<Level> landKey;
    ArtifactType artifactType;
    private GristType baseGrist;
    private final Set<String> givenItemList = new HashSet<String>();
    private ListTag lastEditmodeInventory;

    SburbPlayerData(PlayerIdentifier playerId, MinecraftServer mcServer) {
        this.playerId = playerId;
        this.mcServer = mcServer;
    }

    void read(CompoundTag tag) {
        if (tag.contains("inventory", 9)) {
            this.lastEditmodeInventory = tag.getList("inventory", 10);
        }
        ListTag list = tag.getList("given_items", 8);
        for (int i = 0; i < list.size(); ++i) {
            this.givenItemList.add(list.getString(i));
        }
        if (tag.contains("land")) {
            this.landKey = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("land")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
            this.hasEntered = tag.getBoolean("has_entered");
        }
        this.artifactType = ArtifactType.fromInt(tag.getInt("artifact"));
        this.baseGrist = GristHelper.parseGristType(tag.get("base_grist")).orElseGet(() -> SburbHandler.generateGristType(new Random()));
    }

    void write(CompoundTag tag) {
        if (this.lastEditmodeInventory != null) {
            tag.put("inventory", (Tag)this.lastEditmodeInventory);
        }
        ListTag list = new ListTag();
        for (String name : this.givenItemList) {
            list.add((Object)StringTag.valueOf((String)name));
        }
        tag.put("given_items", (Tag)list);
        if (this.landKey != null) {
            Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.landKey).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(keyTag -> tag.put("land", keyTag));
            tag.putBoolean("has_entered", this.hasEntered);
        }
        tag.putInt("artifact", this.artifactType.ordinal());
        tag.put("base_grist", GristHelper.encodeGristType(this.baseGrist));
    }

    void readOldData(CompoundTag tag) {
        if (tag.contains("Inventory", 9)) {
            this.lastEditmodeInventory = tag.getList("Inventory", 10);
        }
        if (tag.contains("GivenItems", 9)) {
            ListTag list = tag.getList("GivenItems", 8);
            for (int i = 0; i < list.size(); ++i) {
                this.givenItemList.add(list.getString(i));
            }
        }
        if (tag.contains("ClientLand")) {
            this.landKey = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("ClientLand")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
            this.hasEntered = tag.getBoolean("has_entered");
        }
        this.artifactType = ArtifactType.fromInt(tag.getInt("artifact"));
        this.baseGrist = GristHelper.parseGristType(tag.get("base_grist")).orElseGet(() -> SburbHandler.generateGristType(new Random()));
    }

    public PlayerIdentifier playerId() {
        return this.playerId;
    }

    public boolean hasEntered() {
        return this.hasEntered;
    }

    @Nullable
    public ResourceKey<Level> getLandDimensionIfEntered() {
        return this.hasEntered() ? this.landKey : null;
    }

    @Nullable
    public ResourceKey<Level> getLandDimension() {
        return this.landKey;
    }

    public void setLand(ResourceKey<Level> dimension) {
        if (this.landKey != null) {
            throw new IllegalStateException("Can't set land twice");
        }
        this.landKey = dimension;
    }

    void resetEntryState() {
        this.hasEntered = false;
        this.landKey = null;
        this.resendEntryState();
    }

    public void setHasEntered() {
        if (this.landKey == null) {
            throw new IllegalStateException("Land has not been initiated, can't have entered now!");
        }
        if (this.hasEntered) {
            throw new IllegalStateException("Can't have entered twice");
        }
        this.hasEntered = true;
        this.resendEntryState();
    }

    private void resendEntryState() {
        ServerPlayer player = this.playerId.getPlayer(this.mcServer);
        if (player != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SkaianetInfoPackets.HasEntered(this.hasEntered), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean hasGivenItem(DeployEntry item) {
        return this.givenItemList.contains(item.getName());
    }

    public void setHasGivenItem(DeployEntry item) {
        if (this.givenItemList.add(item.getName())) {
            this.resendGivenItems();
        }
    }

    public void resetGivenItems() {
        if (!this.givenItemList.isEmpty()) {
            this.givenItemList.clear();
            this.resendGivenItems();
        }
    }

    private void resendGivenItems() {
        EditData data = ServerEditHandler.getData(this.mcServer, this.playerId);
        if (data != null) {
            data.sendGivenItemsToEditor();
        }
    }

    public ListTag getEditmodeInventory() {
        return this.lastEditmodeInventory == null ? null : this.lastEditmodeInventory.copy();
    }

    public void putEditmodeInventory(ListTag nbt) {
        this.lastEditmodeInventory = nbt;
    }

    public GristType getBaseGrist() {
        return this.baseGrist;
    }

    void setBaseGrist(GristType type) {
        if (this.baseGrist != null) {
            throw new IllegalStateException("base grist type has already been set!");
        }
        this.baseGrist = type;
    }

    public static SburbPlayerData get(ServerPlayer player) {
        return SburbPlayerData.get(IdentifierHandler.encode((Player)player), player.server);
    }

    public static SburbPlayerData get(PlayerIdentifier player, MinecraftServer mcServer) {
        return SkaianetData.get(mcServer).getOrCreateData(player);
    }

    public static Optional<SburbPlayerData> getForLand(ServerLevel level) {
        return SburbPlayerData.getForLand((ResourceKey<Level>)level.dimension(), level.getServer());
    }

    public static Optional<SburbPlayerData> getForLand(ResourceKey<Level> level, MinecraftServer mcServer) {
        return SkaianetData.get(mcServer).allPlayerData().stream().filter(data -> data.getLandDimension() == level).findAny();
    }

    static enum ArtifactType {
        APPLE((Supplier<Item>)MSItems.CRUXITE_APPLE),
        POTION((Supplier<Item>)MSItems.CRUXITE_POTION);

        private final Supplier<Item> item;

        private ArtifactType(Supplier<Item> item) {
            this.item = item;
        }

        ItemStack createItemStack() {
            return new ItemStack((ItemLike)this.item.get());
        }

        static ArtifactType fromInt(int ordinal) {
            return ArtifactType.values()[Mth.clamp((int)ordinal, (int)0, (int)(ArtifactType.values().length - 1))];
        }
    }
}

