/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mraof.minestuck.alchemy.GristGutter;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.SkaianetData;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Session {
    private static final Logger LOGGER = LogManager.getLogger();
    final SkaianetData skaianetData;
    private final Set<PlayerIdentifier> players = new HashSet<PlayerIdentifier>();
    private final GristGutter gutter;
    boolean completed;

    Session merge(Session other) {
        this.players.addAll(other.players);
        this.gutter.addGristUnchecked(other.gutter.getCache());
        return this;
    }

    void checkIfCompleted() {
        this.completed = this.computeIsComplete();
    }

    boolean computeIsComplete() {
        if (this.players.isEmpty()) {
            return false;
        }
        return this.players.stream().allMatch(player -> this.skaianetData.getOrCreateData((PlayerIdentifier)player).hasEntered() && this.skaianetData.connections.primaryPartnerForClient((PlayerIdentifier)player).isPresent());
    }

    Session(SkaianetData skaianetData) {
        this.skaianetData = skaianetData;
        this.gutter = new GristGutter(skaianetData.mcServer, this);
    }

    private Session(CompoundTag nbt, SkaianetData skaianetData) {
        this.skaianetData = skaianetData;
        this.gutter = new GristGutter(skaianetData.mcServer, this, (Tag)nbt.getList("gutter", 10));
    }

    boolean containsPlayer(PlayerIdentifier player) {
        return this.players.contains(player);
    }

    public Set<PlayerIdentifier> getPlayers() {
        return this.players;
    }

    public GristGutter getGristGutter() {
        return this.gutter;
    }

    CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        for (PlayerIdentifier player : this.players) {
            CompoundTag playerTag = new CompoundTag();
            player.saveToNBT(playerTag, "player");
            list.add((Object)playerTag);
        }
        nbt.put("players", (Tag)list);
        nbt.put("gutter", this.gutter.write());
        return nbt;
    }

    static Session read(CompoundTag nbt, SkaianetData skaianetData) {
        int i;
        Session s = new Session(nbt, skaianetData);
        ListTag list = nbt.getList("players", 10);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            IdentifierHandler.load(list.getCompound(i2), "player").resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(s.players::add);
        }
        if (nbt.contains("connections", 9)) {
            ListTag connections = nbt.getList("connections", 10);
            LOGGER.info("Loading old save data with {} sburb connections.", (Object)connections.size());
            for (i = 0; i < connections.size(); ++i) {
                CompoundTag connectionTag = connections.getCompound(i);
                skaianetData.connections.readOldConnectionData(connectionTag, s::addPlayer);
                IdentifierHandler.load(connectionTag, "client").result().ifPresent(client -> skaianetData.getOrCreateData((PlayerIdentifier)client).readOldData(connectionTag));
            }
        }
        if (nbt.contains("predefinedPlayers", 9)) {
            ListTag predefinedPlayers = nbt.getList("predefinedPlayers", 10);
            for (i = 0; i < predefinedPlayers.size(); ++i) {
                CompoundTag compound = predefinedPlayers.getCompound(i);
                IdentifierHandler.load(compound, "player").resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(player -> skaianetData.readOldPredefineData((PlayerIdentifier)player, compound));
            }
        }
        return s;
    }

    Session addPlayer(PlayerIdentifier player) {
        this.players.add(player);
        return this;
    }

    Session createSessionSplit(Set<PlayerIdentifier> players) {
        double originalGutterMultiplier = this.gutter.gutterMultiplierForSession();
        Session newSession = new Session(this.skaianetData);
        for (PlayerIdentifier player : players) {
            this.players.remove(player);
            newSession.players.add(player);
        }
        double gutterMultiplier = newSession.gutter.gutterMultiplierForSession();
        MutableGristSet takenGrist = this.gutter.takeFraction(gutterMultiplier / originalGutterMultiplier);
        newSession.gutter.addGristFrom(takenGrist);
        return newSession;
    }
}

