/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.Session;
import com.mraof.minestuck.skaianet.SkaianetData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public abstract sealed class SessionHandler {
    final SkaianetData skaianetData;

    SessionHandler(SkaianetData skaianetData) {
        this.skaianetData = skaianetData;
    }

    static SessionHandler init(boolean globalSession, SkaianetData skaianetData) {
        if (globalSession) {
            return new Global(skaianetData, new Session(skaianetData));
        }
        return new Multi(skaianetData, Collections.emptyList());
    }

    static SessionHandler load(CompoundTag tag, boolean globalSession, SkaianetData skaianetData) {
        if (tag.contains("session", 10)) {
            Session session = Session.read(tag.getCompound("session"), skaianetData);
            if (globalSession) {
                return new Global(skaianetData, session);
            }
            return new Multi(skaianetData, SessionHandler.createSplitSessions(session));
        }
        ListTag sessionsTag = tag.getList("sessions", 10);
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (int i = 0; i < sessionsTag.size(); ++i) {
            sessions.add(Session.read(sessionsTag.getCompound(i), skaianetData));
        }
        if (((Boolean)MinestuckConfig.SERVER.globalSession.get()).booleanValue()) {
            return new Global(skaianetData, sessions.stream().reduce(new Session(skaianetData), Session::merge));
        }
        return new Multi(skaianetData, sessions);
    }

    abstract void write(CompoundTag var1);

    public abstract Optional<Session> getSession(PlayerIdentifier var1);

    public abstract Session getOrCreateSession(PlayerIdentifier var1);

    public boolean isInSameSession(PlayerIdentifier player1, PlayerIdentifier player2) {
        Optional<Session> session = this.getSession(player1);
        return session.isPresent() && session.get().containsPlayer(player2);
    }

    public abstract Set<Session> getSessions();

    boolean doesSessionHaveMaxTier(Session session) {
        return session.completed;
    }

    abstract void onConnect(PlayerIdentifier var1, PlayerIdentifier var2);

    abstract void onDisconnect(PlayerIdentifier var1, PlayerIdentifier var2);

    void newPredefineData(PlayerIdentifier player) {
    }

    Map<Integer, String> getServerList(PlayerIdentifier client) {
        Optional<PlayerIdentifier> primaryServer = this.skaianetData.connections.primaryPartnerForClient(client);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (PlayerIdentifier server : this.skaianetData.computerInteractions.openServerPlayers()) {
            if (!(primaryServer.isPresent() && primaryServer.get().equals(server) || primaryServer.isEmpty() && this.skaianetData.connections.canMakeNewRegularConnectionAsServer(server)) && !this.skaianetData.connections.canMakeSecondaryConnection(client, server)) continue;
            map.put(server.getId(), server.getUsername());
        }
        return map;
    }

    Stream<PlayerIdentifier> playersToCheckForDataSelection(PlayerIdentifier player) {
        return this.getSession(player).stream().flatMap(session -> session.getPlayers().stream().filter(otherPlayer -> !otherPlayer.equals(player)));
    }

    public static SessionHandler get(MinecraftServer server) {
        return SkaianetData.get((MinecraftServer)server).sessionHandler;
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        SessionHandler sessionHandler;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PlayerIdentifier playerId = IdentifierHandler.encode((Player)player2);
        if (playerId != null && (sessionHandler = SessionHandler.get(player2.server)) instanceof Global) {
            Global global = (Global)sessionHandler;
            global.onNewPlayer(playerId);
        }
    }

    private static List<Session> createSplitSessions(Session session) {
        ArrayList<Session> newSessions = new ArrayList<Session>();
        while (!session.getPlayers().isEmpty()) {
            PlayerIdentifier remainingPlayer = session.getPlayers().iterator().next();
            Set<PlayerIdentifier> players = SessionHandler.collectAllConnectedPlayers(remainingPlayer, session.skaianetData);
            if (players.size() == session.getPlayers().size()) {
                newSessions.add(session);
                break;
            }
            Session newSession = session.createSessionSplit(players);
            newSession.checkIfCompleted();
            newSessions.add(newSession);
        }
        return newSessions;
    }

    private static Set<PlayerIdentifier> collectAllConnectedPlayers(PlayerIdentifier player, SkaianetData skaianetData) {
        HashSet<PlayerIdentifier> players = new HashSet<PlayerIdentifier>();
        LinkedList uncheckedPlayers = new LinkedList();
        players.add(player);
        PlayerIdentifier nextPlayer = player;
        while (nextPlayer != null) {
            SessionHandler.findDirectlyConnectedPlayers(nextPlayer, skaianetData, connectedPlayer -> {
                if (players.add((PlayerIdentifier)connectedPlayer)) {
                    uncheckedPlayers.add(connectedPlayer);
                }
            });
            nextPlayer = (PlayerIdentifier)uncheckedPlayers.poll();
        }
        return players;
    }

    private static void findDirectlyConnectedPlayers(PlayerIdentifier player, SkaianetData skaianetData, Consumer<PlayerIdentifier> playerConsumer) {
        skaianetData.connections.primaryPartnerForClient(player).ifPresent(playerConsumer);
        skaianetData.connections.primaryPartnerForServer(player).ifPresent(playerConsumer);
        skaianetData.connections.getActiveConnection(player).ifPresent(connection -> playerConsumer.accept(connection.server()));
        skaianetData.connections.activeConnections().filter(connection -> connection.server().equals(player)).forEach(connection -> playerConsumer.accept(connection.client()));
    }

    private static final class Global
    extends SessionHandler {
        @Nonnull
        private final Session globalSession;

        Global(SkaianetData skaianetData, Session session) {
            super(skaianetData);
            this.globalSession = Objects.requireNonNull(session);
            skaianetData.players().forEach(this.globalSession::addPlayer);
        }

        void onNewPlayer(PlayerIdentifier player) {
            this.globalSession.addPlayer(player);
        }

        @Override
        void write(CompoundTag compound) {
            compound.put("session", (Tag)this.globalSession.write());
        }

        @Override
        public Optional<Session> getSession(PlayerIdentifier player) {
            return Optional.of(this.globalSession);
        }

        @Override
        public Session getOrCreateSession(PlayerIdentifier player) {
            return this.globalSession;
        }

        @Override
        public boolean isInSameSession(PlayerIdentifier player1, PlayerIdentifier player2) {
            return true;
        }

        @Override
        public Set<Session> getSessions() {
            return Collections.singleton(this.globalSession);
        }

        @Override
        boolean doesSessionHaveMaxTier(Session session) {
            return false;
        }

        @Override
        void onConnect(PlayerIdentifier client, PlayerIdentifier server) {
            this.globalSession.addPlayer(client).addPlayer(server);
        }

        @Override
        void onDisconnect(PlayerIdentifier client, PlayerIdentifier server) {
        }

        @Override
        void newPredefineData(PlayerIdentifier player) {
            this.globalSession.addPlayer(player);
        }
    }

    private static final class Multi
    extends SessionHandler {
        private final Set<Session> sessions = new HashSet<Session>();

        Multi(SkaianetData skaianetData, List<Session> sessions) {
            super(skaianetData);
            this.sessions.addAll(sessions);
            this.sessions.forEach(Session::checkIfCompleted);
        }

        @Override
        void write(CompoundTag compound) {
            ListTag list = new ListTag();
            for (Session s : this.sessions) {
                list.add((Object)s.write());
            }
            compound.put("sessions", (Tag)list);
        }

        @Override
        public Optional<Session> getSession(PlayerIdentifier player) {
            return this.sessions.stream().filter(s -> s.containsPlayer(player)).findAny();
        }

        @Override
        public Session getOrCreateSession(PlayerIdentifier player) {
            Optional<Session> session = this.getSession(player);
            if (session.isPresent()) {
                return session.get();
            }
            Session newSession = new Session(this.skaianetData).addPlayer(player);
            this.sessions.add(newSession);
            return newSession;
        }

        @Override
        public Set<Session> getSessions() {
            return Collections.unmodifiableSet(this.sessions);
        }

        @Override
        void onConnect(PlayerIdentifier client, PlayerIdentifier server) {
            Session serverSession;
            Session clientSession = this.getOrCreateSession(client);
            if (clientSession == (serverSession = this.getOrCreateSession(server))) {
                return;
            }
            if (clientSession.getPlayers().size() < serverSession.getPlayers().size()) {
                this.sessions.remove(clientSession);
                serverSession.merge(clientSession);
            } else {
                this.sessions.remove(serverSession);
                clientSession.merge(serverSession);
            }
        }

        @Override
        void onDisconnect(PlayerIdentifier client, PlayerIdentifier server) {
            Optional<Session> s = this.getSession(client);
            if (s.isPresent() && s.get().containsPlayer(server) && !this.skaianetData.connections.isPrimaryPair(client, server)) {
                this.sessions.remove(s.get());
                this.sessions.addAll(SessionHandler.createSplitSessions(s.get()));
            }
        }
    }
}

