/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.skaianet.SkaianetData;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck")
public final class SessionPostFixer {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        for (SburbPlayerData playerData : SkaianetData.get(event.getServer()).allPlayerData()) {
            SessionPostFixer.validate(event.getServer(), playerData);
        }
    }

    private static void validate(MinecraftServer mcServer, SburbPlayerData playerData) {
        if (playerData.getLandDimension() != null && mcServer.getLevel(playerData.getLandDimension()) == null) {
            LOGGER.error("Found missing land dimension \"{}\" in the connection for player {}. Resetting entry status.", playerData.getLandDimension(), (Object)playerData.playerId().getUsername());
            playerData.resetEntryState();
        }
    }
}

