/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.ComputerInteractions;
import com.mraof.minestuck.skaianet.InfoTracker;
import com.mraof.minestuck.skaianet.PredefineData;
import com.mraof.minestuck.skaianet.SburbConnections;
import com.mraof.minestuck.skaianet.SburbHandler;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.skaianet.SessionHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class SkaianetData
extends SavedData {
    private static final Logger LOGGER = LogManager.getLogger();
    final InfoTracker infoTracker = new InfoTracker(this);
    final ComputerInteractions computerInteractions;
    final SburbConnections connections;
    final SessionHandler sessionHandler;
    private final Map<PlayerIdentifier, SburbPlayerData> playerDataMap = new HashMap<PlayerIdentifier, SburbPlayerData>();
    private final Map<PlayerIdentifier, PredefineData> predefineData = new HashMap<PlayerIdentifier, PredefineData>();
    final MinecraftServer mcServer;
    private static final String DATA_NAME = "minestuck_skaianet";

    private SkaianetData(boolean globalSession, MinecraftServer mcServer) {
        this.mcServer = mcServer;
        this.computerInteractions = new ComputerInteractions(this);
        this.connections = new SburbConnections(this);
        this.sessionHandler = SessionHandler.init(globalSession, this);
    }

    private SkaianetData(MinecraftServer mcServer, CompoundTag nbt) {
        this.mcServer = mcServer;
        ListTag playerDataList = nbt.getList("player_data", 10);
        for (int i = 0; i < playerDataList.size(); ++i) {
            CompoundTag playerDataTag = playerDataList.getCompound(i);
            IdentifierHandler.load(playerDataTag, "player").resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(player -> this.getOrCreateData((PlayerIdentifier)player).read(playerDataTag));
        }
        if (nbt.contains("predefine_data", 9)) {
            ListTag list = nbt.getList("predefine_data", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compound = list.getCompound(i);
                IdentifierHandler.load(compound, "player").resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(player -> this.predefineData.put((PlayerIdentifier)player, new PredefineData((PlayerIdentifier)player).read(compound)));
            }
        }
        this.computerInteractions = new ComputerInteractions(this, nbt);
        this.connections = new SburbConnections(this, nbt);
        this.sessionHandler = SessionHandler.load(nbt, (Boolean)MinestuckConfig.SERVER.globalSession.get(), this);
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        ListTag playerDataList = new ListTag();
        for (SburbPlayerData playerData : this.playerDataMap.values()) {
            CompoundTag playerDataTag = new CompoundTag();
            playerData.playerId().saveToNBT(playerDataTag, "player");
            playerData.write(playerDataTag);
            playerDataList.add((Object)playerDataTag);
        }
        compound.put("player_data", (Tag)playerDataList);
        ListTag predefineList = new ListTag();
        for (Map.Entry<PlayerIdentifier, PredefineData> entry : this.predefineData.entrySet()) {
            predefineList.add((Object)entry.getKey().saveToNBT(entry.getValue().write(), "player"));
        }
        compound.put("predefine_data", (Tag)predefineList);
        this.computerInteractions.write(compound);
        this.connections.write(compound);
        this.sessionHandler.write(compound);
        return compound;
    }

    static SkaianetData newInstanceForGameTest(boolean globalSession, GameTestHelper helper) {
        return new SkaianetData(globalSession, helper.getLevel().getServer());
    }

    SburbPlayerData getOrCreateData(PlayerIdentifier player) {
        return this.playerDataMap.computeIfAbsent(player, playerId -> {
            SburbPlayerData data = new SburbPlayerData((PlayerIdentifier)playerId, this.mcServer);
            SburbHandler.initNewData(data);
            return data;
        });
    }

    Collection<PlayerIdentifier> players() {
        return List.copyOf(this.playerDataMap.keySet());
    }

    public Collection<SburbPlayerData> allPlayerData() {
        return this.playerDataMap.values();
    }

    public Optional<PredefineData> getOrCreatePredefineData(PlayerIdentifier player) {
        if (this.getOrCreateData(player).getLandDimension() != null) {
            return Optional.empty();
        }
        return Optional.of(this.predefineData.computeIfAbsent(player, newPlayer -> {
            this.sessionHandler.newPredefineData((PlayerIdentifier)newPlayer);
            return new PredefineData((PlayerIdentifier)newPlayer);
        }));
    }

    void readOldPredefineData(PlayerIdentifier player, CompoundTag tag) {
        if (this.getOrCreateData(player).getLandDimension() == null) {
            this.predefineData.computeIfAbsent(player, PredefineData::new).read(tag);
        }
    }

    void removePredefineData(PlayerIdentifier player) {
        this.predefineData.remove(player);
    }

    public static SkaianetData get(MinecraftServer server) {
        Objects.requireNonNull(server);
        ServerLevel level = server.overworld();
        DimensionDataStorage storage = level.getDataStorage();
        return (SkaianetData)storage.computeIfAbsent(SkaianetData.factory(server), DATA_NAME);
    }

    private static SavedData.Factory<SkaianetData> factory(MinecraftServer mcServer) {
        return new SavedData.Factory(() -> new SkaianetData((Boolean)MinestuckConfig.SERVER.globalSession.get(), mcServer), (nbt, provider) -> new SkaianetData(mcServer, (CompoundTag)nbt));
    }

    public boolean isDirty() {
        return true;
    }
}

