/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet;

import com.mojang.datafixers.util.Pair;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.entry.EntryProcess;
import com.mraof.minestuck.network.TitleSelectPackets;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.skaianet.SburbHandler;
import com.mraof.minestuck.skaianet.SkaianetData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public class TitleSelectionHook {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Player, Pair<Vec3, BlockPos>> playersInTitleSelection = new HashMap<Player, Pair<Vec3, BlockPos>>();

    public static boolean performEntryCheck(ServerPlayer player, BlockPos savedPos) {
        if (!((Boolean)MinestuckConfig.SERVER.playerSelectedTitle.get()).booleanValue()) {
            return true;
        }
        PlayerIdentifier identifier = IdentifierHandler.encode((Player)player);
        if (SkaianetData.get(player.server).getOrCreatePredefineData(identifier).map(data -> data.getTitle() != null).orElse(false).booleanValue() || Title.getTitle(identifier, player.server).isPresent()) {
            return true;
        }
        playersInTitleSelection.put((Player)player, (Pair<Vec3, BlockPos>)new Pair((Object)new Vec3(player.getX(), player.getY(), player.getZ()), (Object)savedPos));
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new TitleSelectPackets.OpenScreen(Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return false;
    }

    public static void cancelSelection(ServerPlayer player) {
        playersInTitleSelection.remove(player);
    }

    public static void handleTitleSelection(ServerPlayer player, @Nullable Title title) {
        if (!((Boolean)MinestuckConfig.SERVER.playerSelectedTitle.get()).booleanValue() || !playersInTitleSelection.containsKey(player)) {
            LOGGER.warn("{} tried to select a title without entering.", (Object)player.getName().getString());
            return;
        }
        PlayerIdentifier identifier = IdentifierHandler.encode((Player)player);
        if (title == null) {
            SburbHandler.generateAndSetTitle(identifier, player.server);
        } else {
            Title.setTitle(PlayerData.get(identifier, player.server), title);
        }
        Pair<Vec3, BlockPos> both = playersInTitleSelection.remove(player);
        Vec3 previousPlayerPos = (Vec3)both.getFirst();
        player.setPos(previousPlayerPos.x, previousPlayerPos.y, previousPlayerPos.z);
        BlockPos specifiedPos = (BlockPos)both.getSecond();
        EntryProcess.enter(player, specifiedPos);
    }

    @SubscribeEvent
    public static void serverStopped(ServerStoppedEvent event) {
        playersInTitleSelection.clear();
    }
}

