/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.skaianet.client;

import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.MSScreenFactories;
import com.mraof.minestuck.client.gui.computer.ComputerScreen;
import com.mraof.minestuck.network.computer.SkaianetInfoPackets;
import com.mraof.minestuck.skaianet.LandChain;
import com.mraof.minestuck.skaianet.client.ReducedConnection;
import com.mraof.minestuck.skaianet.client.ReducedPlayerState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public final class SkaiaClient {
    private static final Map<Integer, ReducedPlayerState> playerStateMap = new HashMap<Integer, ReducedPlayerState>();
    private static final List<ReducedConnection> connections = new ArrayList<ReducedConnection>();
    private static final Map<ResourceKey<Level>, LandChain> landChainMap = new HashMap<ResourceKey<Level>, LandChain>();
    private static ComputerBlockEntity be = null;
    public static int playerId;
    private static boolean hasEntered;

    @SubscribeEvent
    public static void onLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        playerStateMap.clear();
        connections.clear();
        landChainMap.clear();
        playerId = -1;
        hasEntered = false;
    }

    public static boolean requestData(ComputerBlockEntity computer) {
        boolean b;
        boolean bl = b = playerStateMap.get(computer.clientSideOwnerId()) != null;
        if (!b) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SkaianetInfoPackets.Request(computer.clientSideOwnerId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            be = computer;
        }
        return b;
    }

    public static boolean hasPrimaryConnectionAsClient(int playerId) {
        return playerStateMap.get(playerId).hasPrimaryConnectionAsClient();
    }

    public static boolean hasPrimaryConnectionAsServer(int playerId) {
        return playerStateMap.get(playerId).hasPrimaryConnectionAsServer();
    }

    public static Map<Integer, String> getAvailableServers(Integer playerId) {
        return playerStateMap.get(playerId).openServers();
    }

    public static boolean hasPlayerEntered() {
        return hasEntered;
    }

    @Nullable
    public static LandChain getLandChain(ResourceKey<Level> id) {
        return landChainMap.get(id);
    }

    public static boolean isActive(int playerId, boolean isClient) {
        if (isClient) {
            return SkaiaClient.getClientConnection(playerId) != null || playerStateMap.get(playerId).isClientResuming();
        }
        return playerStateMap.get(playerId).isServerResuming();
    }

    public static boolean canSelect(int playerId) {
        if (playerId != SkaiaClient.playerId) {
            return false;
        }
        if (playerStateMap.get(playerId).hasPrimaryConnectionAsClient()) {
            return false;
        }
        return connections.stream().noneMatch(c -> c.client().id() == playerId);
    }

    @Nullable
    public static ReducedConnection getClientConnection(int client) {
        for (ReducedConnection c : connections) {
            if (c.client().id() != client) continue;
            return c;
        }
        return null;
    }

    public static void handlePacket(SkaianetInfoPackets.Data data) {
        if (playerId == -1) {
            playerId = data.playerId();
        }
        playerStateMap.put(data.playerId(), data.playerState());
        connections.removeIf(c -> c.client().id() == data.playerId() || c.server().id() == data.playerId());
        connections.addAll(data.connections());
        Screen gui = Minecraft.getInstance().screen;
        if (gui instanceof ComputerScreen) {
            ComputerScreen computerScreen = (ComputerScreen)gui;
            computerScreen.updateGui();
        } else if (be != null && be.clientSideOwnerId() == data.playerId()) {
            if (!Minecraft.getInstance().player.isShiftKeyDown()) {
                MSScreenFactories.displayComputerScreen(be);
            }
            be = null;
        }
    }

    public static void handlePacket(SkaianetInfoPackets.LandChains packet) {
        landChainMap.clear();
        for (LandChain landChain : packet.landChains()) {
            landChain.lands().forEach(land -> landChainMap.put((ResourceKey<Level>)land, landChain));
        }
    }

    public static void handlePacket(SkaianetInfoPackets.HasEntered packet) {
        hasEntered = packet.hasEntered();
    }
}

