/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.util;

import com.mojang.datafixers.util.Pair;
import com.mraof.minestuck.event.AlchemyEvent;
import com.mraof.minestuck.item.AlchemizedColored;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.network.PlayerColorPackets;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.SburbHandler;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.util.MSAttachments;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class ColorHandler {
    @SubscribeEvent
    private static void onAlchemy(AlchemyEvent event) {
        ItemStack stack = event.getItemResult();
        Item item = stack.getItem();
        if (item instanceof AlchemizedColored) {
            AlchemizedColored colored = (AlchemizedColored)item;
            int color = ColorHandler.getColorForPlayer(event.getPlayer(), event.getLevel());
            event.setItemResult(colored.setColor(stack, color));
        }
    }

    public static ItemStack setDefaultColor(ItemStack stack) {
        return ColorHandler.setColor(stack, 10542335);
    }

    public static ItemStack setColor(ItemStack stack, int color) {
        stack.set(MSItemComponents.COLOR, (Object)color);
        return stack;
    }

    public static int getColorFromStack(ItemStack stack) {
        return (Integer)stack.getOrDefault(MSItemComponents.COLOR, (Object)10542335);
    }

    public static int getColorForDimension(ServerLevel level) {
        return SburbPlayerData.getForLand(level).map(data -> ColorHandler.getColorForPlayer(data.playerId(), (Level)level)).orElse(10542335);
    }

    public static int getColorForPlayer(ServerPlayer player) {
        return ColorHandler.getColorForPlayer(IdentifierHandler.encode((Player)player), player.level());
    }

    public static int getColorForPlayer(PlayerIdentifier identifier, Level level) {
        return (Integer)PlayerData.get(identifier, level).getData(MSAttachments.PLAYER_COLOR);
    }

    public static void trySetPlayerColor(ServerPlayer player, int color) {
        PlayerIdentifier playerId = IdentifierHandler.encode((Player)player);
        if (playerId == null || !SburbHandler.canSelectColor(playerId, player.server)) {
            return;
        }
        PlayerData playerData = PlayerData.get(playerId, player.server);
        Integer prevColor = (Integer)playerData.setData(MSAttachments.PLAYER_COLOR, color);
        if (!Objects.equals(prevColor, color)) {
            player.connection.send((CustomPacketPayload)new PlayerColorPackets.Data(color));
        }
    }

    @SubscribeEvent
    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        PlayerData playerData = PlayerData.get(player).orElseThrow();
        boolean firstTime = playerData.getExistingData(MSAttachments.PLAYER_COLOR).isEmpty();
        if (firstTime && !player.isSpectator()) {
            playerData.setData(MSAttachments.PLAYER_COLOR, 10542335);
            player.connection.send((CustomPacketPayload)new PlayerColorPackets.OpenSelection());
        } else {
            player.connection.send((CustomPacketPayload)new PlayerColorPackets.Data((Integer)playerData.getData(MSAttachments.PLAYER_COLOR)));
        }
    }

    public static final class BuiltinColors {
        public static final int DEFAULT_COLOR = 10542335;
        private static final List<Pair<Integer, String>> COLORS = List.of(Pair.of((Object)464333, (Object)"blue"), Pair.of((Object)11876058, (Object)"orchid"), Pair.of((Object)0xE00707, (Object)"red"), Pair.of((Object)4901157, (Object)"green"), Pair.of((Object)54770, (Object)"cyan"), Pair.of((Object)0xFF6FF2, (Object)"pink"), Pair.of((Object)15901696, (Object)"orange"), Pair.of((Object)2069504, (Object)"emerald"), Pair.of((Object)0xA10000, (Object)"rust"), Pair.of((Object)10571776, (Object)"bronze"), Pair.of((Object)0xA1A100, (Object)"gold"), Pair.of((Object)0x626262, (Object)"iron"), Pair.of((Object)4285952, (Object)"olive"), Pair.of((Object)33089, (Object)"jade"), Pair.of((Object)33410, (Object)"teal"), Pair.of((Object)22146, (Object)"cobalt"), Pair.of((Object)86, (Object)"indigo"), Pair.of((Object)2818135, (Object)"purple"), Pair.of((Object)0x6A006A, (Object)"violet"), Pair.of((Object)7798844, (Object)"fuchsia"));

        public static int getColor(int index) {
            if (index < 0 || index >= COLORS.size()) {
                return 10542335;
            }
            return (Integer)COLORS.get(index).getFirst();
        }

        public static Component getName(int index) {
            if (index < 0 || index >= COLORS.size()) {
                return Component.literal((String)"INVALID");
            }
            return Component.translatable((String)("minestuck.color." + (String)COLORS.get(index).getSecond()));
        }
    }
}

