/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.util;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.computer.editmode.EditTools;
import com.mraof.minestuck.computer.editmode.EditmodeLocations;
import com.mraof.minestuck.entity.consort.ConsortReputation;
import com.mraof.minestuck.entity.dialogue.DialogueComponent;
import com.mraof.minestuck.fluid.MSFluidType;
import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.musicplayer.MusicPlaying;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.Title;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class MSAttachments {
    public static final DeferredRegister<AttachmentType<?>> REGISTER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"minestuck");
    public static final Supplier<AttachmentType<CaptchaDeckHandler.ModusHolder>> MODUS_HOLDER = REGISTER.register("modus_holder", () -> AttachmentType.serializable(MSAttachments.restricted(CaptchaDeckHandler.ModusHolder::new, PlayerData.class)).build());
    public static final Supplier<AttachmentType<Integer>> PLAYER_COLOR = REGISTER.register("player_color", () -> AttachmentType.builder(MSAttachments.restricted(() -> 10542335, PlayerData.class)).serialize((Codec)Codec.INT).build());
    public static final Supplier<AttachmentType<Long>> BOONDOLLARS = REGISTER.register("boondollars", () -> AttachmentType.builder(MSAttachments.restricted(() -> 0L, PlayerData.class)).serialize((Codec)Codec.LONG).build());
    public static final Supplier<AttachmentType<GristCache>> GRIST_CACHE = REGISTER.register("grist_cache", () -> AttachmentType.serializable(MSAttachments.restricted(GristCache::new, PlayerData.class)).build());
    public static final Supplier<AttachmentType<Double>> GUTTER_MULTIPLIER = REGISTER.register("gutter_multiplier", () -> AttachmentType.builder(MSAttachments.restricted(() -> 1.0, PlayerData.class)).serialize((Codec)Codec.DOUBLE).build());
    public static final Supplier<AttachmentType<Echeladder>> ECHELADDER = REGISTER.register("echeladder", () -> AttachmentType.serializable(MSAttachments.restricted(Echeladder::new, PlayerData.class)).build());
    public static final Supplier<AttachmentType<Title>> TITLE = REGISTER.register("title", () -> AttachmentType.builder(MSAttachments.noDefault()).serialize(Title.CODEC).build());
    public static final Supplier<AttachmentType<Boolean>> EFFECT_TOGGLE = REGISTER.register("effect_toggle", () -> AttachmentType.builder(MSAttachments.restricted(() -> false, ServerPlayer.class)).serialize((Codec)Codec.BOOL).build());
    public static final Supplier<AttachmentType<EditmodeLocations>> EDITMODE_LOCATIONS = REGISTER.register("editmode_locations", () -> AttachmentType.serializable(MSAttachments.restricted(EditmodeLocations::new, PlayerData.class)).build());
    public static final Supplier<AttachmentType<EditTools>> EDIT_TOOLS = REGISTER.register("edit_tools", () -> AttachmentType.builder(MSAttachments.restricted(EditTools::new, Player.class)).build());
    public static final Supplier<AttachmentType<ConsortReputation>> CONSORT_REPUTATION = REGISTER.register("consort_reputation", () -> AttachmentType.serializable(MSAttachments.restricted(ConsortReputation::new, PlayerData.class)).build());
    public static final Supplier<AttachmentType<DialogueComponent.CurrentDialogue>> CURRENT_DIALOGUE = REGISTER.register("current_dialogue", () -> AttachmentType.builder(MSAttachments.restricted(DialogueComponent.CurrentDialogue::new, ServerPlayer.class)).build());
    public static final Supplier<AttachmentType<MusicPlaying>> MUSIC_PLAYING = REGISTER.register("music_playing", () -> AttachmentType.builder(MSAttachments.restricted(MusicPlaying::new, LivingEntity.class)).build());
    public static final Supplier<AttachmentType<MSFluidType.LastFluidTickData>> LAST_FLUID_TICK = REGISTER.register("last_fluid_tick", () -> AttachmentType.builder(MSAttachments.restricted(MSFluidType.LastFluidTickData::new, LivingEntity.class)).build());

    private static <T> Supplier<T> noDefault() {
        return () -> {
            throw new UnsupportedOperationException("This attachment does not support default values. Use 'getExistingData()' instead.");
        };
    }

    private static <H extends IAttachmentHolder, T> Function<IAttachmentHolder, T> restricted(Supplier<T> defaultValueSupplier, Class<H> permittedHolder) {
        return MSAttachments.restricted((H holder) -> defaultValueSupplier.get(), permittedHolder);
    }

    private static <H extends IAttachmentHolder, T> Function<IAttachmentHolder, T> restricted(Function<H, T> defaultValueSupplier, Class<H> permittedHolder) {
        return holder -> {
            if (!permittedHolder.isInstance(holder)) {
                throw new UnsupportedOperationException("Only a holder of class " + String.valueOf(permittedHolder) + " is permitted.");
            }
            return defaultValueSupplier.apply((IAttachmentHolder)permittedHolder.cast(holder));
        };
    }
}

