/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.util;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;

public class MSTags {
    public static Set<Block> getBlocksFromTag(TagKey<Block> blockTag) {
        return BuiltInRegistries.BLOCK.getTag(blockTag).stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).collect(Collectors.toSet());
    }

    public static List<ItemStack> getItemStacksFromTag(TagKey<Item> itemTag) {
        return BuiltInRegistries.ITEM.getTag(itemTag).stream().flatMap(HolderSet.ListBacked::stream).map(ItemStack::new).toList();
    }

    public static class TitleLandTypes {
        public static final TagKey<TitleLandType> MONSTERS = TitleLandTypes.tag("monsters");

        private static TagKey<TitleLandType> tag(String name) {
            return TagKey.create(LandTypes.TITLE_KEY, (ResourceLocation)Minestuck.id(name));
        }
    }

    public static class PaintingVariants {
        public static final TagKey<PaintingVariant> SBAHJ_POSTERS = PaintingVariants.tag("sbahj_posters");
        public static final TagKey<PaintingVariant> MIDNIGHT_CREW_POSTERS = PaintingVariants.tag("midnight_crew_posters");
        public static final TagKey<PaintingVariant> SHOP_POSTERS = PaintingVariants.tag("shop_posters");

        private static TagKey<PaintingVariant> tag(String name) {
            return TagKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)Minestuck.id(name));
        }
    }

    public static class TerrainLandTypes {
        public static final TagKey<TerrainLandType> FOREST = TerrainLandTypes.tag("forest");
        public static final TagKey<TerrainLandType> ROCK = TerrainLandTypes.tag("rock");
        public static final TagKey<TerrainLandType> SAND = TerrainLandTypes.tag("sand");
        public static final TagKey<TerrainLandType> SANDSTONE = TerrainLandTypes.tag("sandstone");
        public static final TagKey<TerrainLandType> IS_DESOLATE = TerrainLandTypes.tag("is_desolate");
        public static final TagKey<TerrainLandType> IS_DANGEROUS = TerrainLandTypes.tag("is_dangerous");
        public static final TagKey<TerrainLandType> IS_FLUID_IMPORTANT = TerrainLandTypes.tag("is_fluid_important");

        private static TagKey<TerrainLandType> tag(String name) {
            return TagKey.create(LandTypes.TERRAIN_KEY, (ResourceLocation)Minestuck.id(name));
        }
    }

    public static class Structures {
        public static final TagKey<Structure> SCANNER_LOCATED = Structures.tag("scanner_located");

        private static TagKey<Structure> tag(String name) {
            return TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)Minestuck.id(name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> HAS_FROG_TEMPLE = Biomes.tag("has_structure/frog_temple");
        public static final TagKey<Biome> LAND_NORMAL = Biomes.tag("land/normal");
        public static final TagKey<Biome> LAND_OCEAN = Biomes.tag("land/ocean");
        public static final TagKey<Biome> LAND_ROUGH = Biomes.tag("land/rough");
        public static final TagKey<Biome> LAND = Biomes.tag("land");
        public static final TagKey<Biome> HAS_LAND_GATE = Biomes.tag("has_structure/land_gate");
        public static final TagKey<Biome> HAS_SMALL_RUIN = Biomes.tag("has_structure/small_ruin");
        public static final TagKey<Biome> HAS_IMP_DUNGEON = Biomes.tag("has_structure/imp_dungeon");
        public static final TagKey<Biome> HAS_CONSORT_VILLAGE = Biomes.tag("has_structure/consort_village");
        public static final TagKey<Biome> HAS_SKAIA_CASTLE = Biomes.tag("has_structure/skaia_castle");
        public static final TagKey<Biome> HAS_SKAIAN_CATHEDRAL = Biomes.tag("has_structure/skaian_cathedral");

        private static TagKey<Biome> tag(String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Minestuck.id(name));
        }
    }

    public static class Effects {
        public static final TagKey<MobEffect> SOPOR_SICKNESS_WHITELIST = Effects.tag("sopor_sickness_whitelist");

        private static TagKey<MobEffect> tag(String name) {
            return TagKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)Minestuck.id(name));
        }
    }

    public static class EntityTypes {
        public static final TagKey<EntityType<?>> UNDERLINGS = EntityTypes.tag("underlings");
        public static final TagKey<EntityType<?>> CONSORTS = EntityTypes.tag("consorts");
        public static final TagKey<EntityType<?>> CARAPACIANS = EntityTypes.tag("carapacians");
        public static final TagKey<EntityType<?>> DERSITE_CARAPACIANS = EntityTypes.tag("carapacians/dersite");
        public static final TagKey<EntityType<?>> PROSPITIAN_CARAPACIANS = EntityTypes.tag("carapacians/prospitian");
        public static final TagKey<EntityType<?>> PAWNS = EntityTypes.tag("carapacians/pawn");
        public static final TagKey<EntityType<?>> BISHOPS = EntityTypes.tag("carapacians/bishop");
        public static final TagKey<EntityType<?>> ROOKS = EntityTypes.tag("carapacians/rook");
        public static final TagKey<EntityType<?>> MAGNET_RECEPTIVE = EntityTypes.tag("magnet_receptive");
        public static final TagKey<EntityType<?>> REMOTE_OBSERVER_BLACKLIST = EntityTypes.tag("remote_observer_blacklist");
        public static final TagKey<EntityType<?>> BOSS_MOB = EntityTypes.tag("boss_mob");

        private static TagKey<EntityType<?>> tag(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Minestuck.id(name));
        }
    }

    public static class Fluids {
        public static final TagKey<Fluid> OIL = Fluids.tag("oil");
        public static final TagKey<Fluid> BLOOD = Fluids.tag("blood");
        public static final TagKey<Fluid> BRAIN_JUICE = Fluids.tag("brain_juice");
        public static final TagKey<Fluid> WATER_COLORS = Fluids.tag("water_colors");
        public static final TagKey<Fluid> ENDER = Fluids.tag("ender");
        public static final TagKey<Fluid> LIGHT_WATER = Fluids.tag("light_water");
        public static final TagKey<Fluid> CAULK = Fluids.tag("caulk");

        private static TagKey<Fluid> tag(String name) {
            return FluidTags.create((ResourceLocation)Minestuck.id(name));
        }
    }

    public static class Items {
        public static final TagKey<Item> GLOWING_LOGS = Items.tag("logs/glowing");
        public static final TagKey<Item> FROST_LOGS = Items.tag("logs/frost");
        public static final TagKey<Item> RAINBOW_LOGS = Items.tag("logs/rainbow");
        public static final TagKey<Item> END_LOGS = Items.tag("logs/end");
        public static final TagKey<Item> VINE_LOGS = Items.tag("logs/vine");
        public static final TagKey<Item> FLOWERY_VINE_LOGS = Items.tag("logs/flowery_vine");
        public static final TagKey<Item> DEAD_LOGS = Items.tag("logs/dead");
        public static final TagKey<Item> CINDERED_LOGS = Items.tag("logs/cindered");
        public static final TagKey<Item> PETRIFIED_LOGS = Items.tag("logs/petrified");
        public static final TagKey<Item> ASPECT_LOGS = Items.tag("logs/aspect");
        public static final TagKey<Item> ASPECT_WOOD = Items.tag("wood/aspect");
        public static final TagKey<Item> ASPECT_PLANKS = Items.tag("planks/aspect");
        public static final TagKey<Item> ASPECT_SLABS = Items.tag("slabs/aspect");
        public static final TagKey<Item> ASPECT_LEAVES = Items.tag("leaves/aspect");
        public static final TagKey<Item> ASPECT_SAPLINGS = Items.tag("saplings/aspect");
        public static final TagKey<Item> SHADEWOOD_LOGS = Items.tag("logs/shadewood");
        public static final TagKey<Item> SHADEWOOD_LEAVES = Items.tag("leaves/shadewood");
        public static final TagKey<Item> CRUXITE_ORES = Items.tag("ores/cruxite");
        public static final TagKey<Item> URANIUM_ORES = Items.tag("ores/uranium");
        public static final TagKey<Item> COAL_ORES = Items.tag("ores/coal");
        public static final TagKey<Item> IRON_ORES = Items.tag("ores/iron");
        public static final TagKey<Item> GOLD_ORES = Items.tag("ores/gold");
        public static final TagKey<Item> REDSTONE_ORES = Items.tag("ores/redstone");
        public static final TagKey<Item> QUARTZ_ORES = Items.tag("ores/quartz");
        public static final TagKey<Item> LAPIS_ORES = Items.tag("ores/lapis");
        public static final TagKey<Item> DIAMOND_ORES = Items.tag("ores/diamond");
        public static final TagKey<Item> EMERALD_ORES = Items.tag("ores/emerald");
        public static final TagKey<Item> CRUXITE_STORAGE_BLOCKS = Items.tag("storage_blocks/cruxite");
        public static final TagKey<Item> GRIST_CANDY = Items.tag("grist_candy");
        public static final TagKey<Item> FAYGO = Items.tag("faygo");
        public static final TagKey<Item> MODUS_CARD = Items.tag("modus_card");
        public static final TagKey<Item> CASSETTES = Items.tag("cassettes");
        public static final TagKey<Item> BUGS = Items.tag("bugs");
        public static final TagKey<Item> CONSORT_SNACKS = Items.tag("consort_snacks");
        public static final TagKey<Item> MAGIC_WEAPON = Items.tag("magic_weapon");
        public static final TagKey<Item> CREATIVE_SHOCK_RIGHT_CLICK_LIMIT = Items.tag("creative_shock_right_click_limit");
        public static final TagKey<Item> UNREADABLE = Items.tag("unreadable");
        public static final TagKey<Item> LEGENDARY = Items.tag("legendary");

        private static TagKey<Item> tag(String name) {
            return ItemTags.create((ResourceLocation)Minestuck.id(name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> GREEN_HIEROGLYPHS = Blocks.tag("green_hieroglyphs");
        public static final TagKey<Block> GLOWING_LOGS = Blocks.tag("logs/glowing");
        public static final TagKey<Block> FROST_LOGS = Blocks.tag("logs/frost");
        public static final TagKey<Block> RAINBOW_LOGS = Blocks.tag("logs/rainbow");
        public static final TagKey<Block> END_LOGS = Blocks.tag("logs/end");
        public static final TagKey<Block> VINE_LOGS = Blocks.tag("logs/vine");
        public static final TagKey<Block> FLOWERY_VINE_LOGS = Blocks.tag("logs/flowery_vine");
        public static final TagKey<Block> DEAD_LOGS = Blocks.tag("logs/dead");
        public static final TagKey<Block> CINDERED_LOGS = Blocks.tag("logs/cindered");
        public static final TagKey<Block> PETRIFIED_LOGS = Blocks.tag("logs/petrified");
        public static final TagKey<Block> ASPECT_LOGS = Blocks.tag("logs/aspect");
        public static final TagKey<Block> ASPECT_WOOD = Blocks.tag("wood/aspect");
        public static final TagKey<Block> ASPECT_PLANKS = Blocks.tag("planks/aspect");
        public static final TagKey<Block> ASPECT_SLABS = Blocks.tag("slabs/aspect");
        public static final TagKey<Block> ASPECT_LEAVES = Blocks.tag("leaves/aspect");
        public static final TagKey<Block> ASPECT_SAPLINGS = Blocks.tag("saplings/aspect");
        public static final TagKey<Block> ASPECT_BOOKSHELVES = Blocks.tag("bookshelves/aspect");
        public static final TagKey<Block> ASPECT_LADDERS = Blocks.tag("ladders/aspect");
        public static final TagKey<Block> ASPECT_POTTED_SAPLINGS = Blocks.tag("flower_pots/aspect");
        public static final TagKey<Block> SHADEWOOD_LOGS = Blocks.tag("logs/shadewood");
        public static final TagKey<Block> SHADEWOOD_LEAVES = Blocks.tag("leaves/shadewood");
        public static final TagKey<Block> WOOD_TERRAIN_BLOCKS = Blocks.tag("terrain/wood_terrain_blocks");
        public static final TagKey<Block> HEAT_TERRAIN_BLOCKS = Blocks.tag("terrain/heat_terrain_blocks");
        public static final TagKey<Block> ASPECT_TREE_PLACEABLE = Blocks.tag("terrain/aspect_tree_placeable");
        public static final TagKey<Block> CRUXITE_ORES = Blocks.tag("ores/cruxite");
        public static final TagKey<Block> URANIUM_ORES = Blocks.tag("ores/uranium");
        public static final TagKey<Block> COAL_ORES = Blocks.tag("ores/coal");
        public static final TagKey<Block> IRON_ORES = Blocks.tag("ores/iron");
        public static final TagKey<Block> GOLD_ORES = Blocks.tag("ores/gold");
        public static final TagKey<Block> REDSTONE_ORES = Blocks.tag("ores/redstone");
        public static final TagKey<Block> QUARTZ_ORES = Blocks.tag("ores/quartz");
        public static final TagKey<Block> LAPIS_ORES = Blocks.tag("ores/lapis");
        public static final TagKey<Block> DIAMOND_ORES = Blocks.tag("ores/diamond");
        public static final TagKey<Block> EMERALD_ORES = Blocks.tag("ores/emerald");
        public static final TagKey<Block> CRUXITE_STORAGE_BLOCKS = Blocks.tag("storage_blocks/cruxite");
        public static final TagKey<Block> END_SAPLING_DIRT = Blocks.tag("end_sapling_dirt");
        public static final TagKey<Block> ROTATOR_WHITELISTED = Blocks.tag("rule_exempt_rotatable");
        public static final TagKey<Block> PLATFORM_ABSORBING = Blocks.tag("platform_absorbing");
        public static final TagKey<Block> PUSHABLE_BLOCK_REPLACEABLE = Blocks.tag("portable_block_replaceable");
        public static final TagKey<Block> PETRIFIED_FLORA_PLACEABLE = Blocks.tag("petrified_flora_placeable");
        public static final TagKey<Block> EDITMODE_BREAK_BLACKLIST = Blocks.tag("editmode_break_blacklist");
        public static final TagKey<Block> FARMINE_BREAK_BLACKLIST = Blocks.tag("farmine_break_blacklist");
        public static final TagKey<Block> MINEABLE_WITH_SICKLE = Blocks.tag("mineable_with_sickle");
        public static final TagKey<Block> MINEABLE_WITH_SCYTHE = Blocks.tag("mineable_with_scythe");
        public static final TagKey<Block> MINEABLE_WITH_CLAWS = Blocks.tag("mineable_with_claws");
        public static final TagKey<Block> MINEABLE_WITH_HAMMER = Blocks.tag("mineable_with_hammer");
        public static final TagKey<Block> MINEABLE_WITH_CHAINSAW = Blocks.tag("mineable_with_chainsaw");
        public static final TagKey<Block> MINEABLE_WITH_LANCE = Blocks.tag("mineable_with_lance");
        public static final TagKey<Block> MINEABLE_WITH_CLUB = Blocks.tag("mineable_with_club");
        public static final TagKey<Block> MINEABLE_WITH_KNIFE = Blocks.tag("mineable_with_knife");
        public static final TagKey<Block> MINEABLE_WITH_KEY = Blocks.tag("mineable_with_key");
        public static final TagKey<Block> MINEABLE_WITH_FAN = Blocks.tag("mineable_with_fan");
        public static final TagKey<Block> MINEABLE_WITH_BATON = Blocks.tag("mineable_with_baton");
        public static final TagKey<Block> MINEABLE_WITH_STAFF = Blocks.tag("mineable_with_staff");
        public static final TagKey<Block> MINEABLE_WITH_CANE = Blocks.tag("mineable_with_cane");
        public static final TagKey<Block> MINEABLE_WITH_FORK = Blocks.tag("mineable_with_fork");
        public static final TagKey<Block> MINEABLE_WITH_SPOON = Blocks.tag("mineable_with_spoon");
        public static final TagKey<Block> MINEABLE_WITH_WAND = Blocks.tag("mineable_with_wand");
        public static final TagKey<Block> INCORRECT_FOR_SBAHJ_TOOL = Blocks.tag("incorrect_for_sbahj_tool");
        public static final TagKey<Block> INCORRECT_FOR_PAPER_TOOL = Blocks.tag("incorrect_for_paper_tool");
        public static final TagKey<Block> INCORRECT_FOR_ORGANIC_TOOL = Blocks.tag("incorrect_for_organic_tool");
        public static final TagKey<Block> INCORRECT_FOR_MEAT_TOOL = Blocks.tag("incorrect_for_meat_tool");
        public static final TagKey<Block> INCORRECT_FOR_CANDY_TOOL = Blocks.tag("incorrect_for_candy_tool");
        public static final TagKey<Block> INCORRECT_FOR_BOOK_TOOL = Blocks.tag("incorrect_for_book_tool");
        public static final TagKey<Block> INCORRECT_FOR_CACTUS_TOOL = Blocks.tag("incorrect_for_cactus_tool");
        public static final TagKey<Block> INCORRECT_FOR_ICE_TOOL = Blocks.tag("incorrect_for_ice_tool");
        public static final TagKey<Block> INCORRECT_FOR_POGO_TOOL = Blocks.tag("incorrect_for_pogo_tool");
        public static final TagKey<Block> INCORRECT_FOR_EMERALD_TOOL = Blocks.tag("incorrect_for_emerald_tool");
        public static final TagKey<Block> INCORRECT_FOR_PRISMARINE_TOOL = Blocks.tag("incorrect_for_prismarine_tool");
        public static final TagKey<Block> INCORRECT_FOR_CORUNDUM_TOOL = Blocks.tag("incorrect_for_corundum_tool");
        public static final TagKey<Block> INCORRECT_FOR_REGI_TOOL = Blocks.tag("incorrect_for_regi_tool");
        public static final TagKey<Block> INCORRECT_FOR_HORRORTERROR_TOOL = Blocks.tag("incorrect_for_horrorterror_tool");
        public static final TagKey<Block> INCORRECT_FOR_URANIUM_TOOL = Blocks.tag("incorrect_for_uranium_tool");
        public static final TagKey<Block> INCORRECT_FOR_BATTERY_TOOL = Blocks.tag("incorrect_for_battery_tool");
        public static final TagKey<Block> INCORRECT_FOR_DENIZEN_TOOL = Blocks.tag("incorrect_for_denizen_tool");
        public static final TagKey<Block> INCORRECT_FOR_ZILLY_TOOL = Blocks.tag("incorrect_for_zilly_tool");
        public static final TagKey<Block> INCORRECT_FOR_WELSH_TOOL = Blocks.tag("incorrect_for_welsh_tool");

        private static TagKey<Block> tag(String name) {
            return BlockTags.create((ResourceLocation)Minestuck.id(name));
        }
    }
}

