/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.util;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class Teleport {
    public static Entity teleportEntity(Entity entity, ServerLevel level) {
        return Teleport.teleportEntity(entity, level, entity.getX(), entity.getY(), entity.getZ());
    }

    public static Entity teleportEntity(Entity entity, ServerLevel level, double x, double y, double z) {
        return Teleport.teleportEntity(entity, level, x, y, z, entity.getYRot(), entity.getXRot());
    }

    public static Entity teleportEntity(Entity entity, ServerLevel level, double x, double y, double z, float yaw, float pitch) {
        LivingEntity living;
        if (!entity.canChangeDimensions(entity.level(), (Level)level)) {
            return null;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ChunkPos chunkpos = new ChunkPos(BlockPos.containing((double)x, (double)y, (double)z));
            level.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)player.getId());
            player.stopRiding();
            if (player.isSleeping()) {
                player.stopSleeping();
            }
            boolean toNewDim = player.level() != level;
            player.teleportTo(level, x, y, z, yaw, pitch);
            if (toNewDim && player.level() != level) {
                return null;
            }
            player.isChangingDimension = true;
            player.setYHeadRot(yaw);
            player.setExperienceLevels(player.experienceLevel);
            player.resetSentInfo();
        } else {
            yaw = Mth.wrapDegrees((float)yaw);
            pitch = Mth.wrapDegrees((float)pitch);
            pitch = Mth.clamp((float)pitch, (float)-90.0f, (float)90.0f);
            if (level == entity.level()) {
                entity.moveTo(x, y, z, yaw, pitch);
                entity.setYHeadRot(yaw);
            } else {
                entity.unRide();
                Entity oldEntity = entity;
                entity = entity.getType().create((Level)level);
                if (entity == null) {
                    return null;
                }
                CompoundTag compoundtag = oldEntity.saveWithoutId(new CompoundTag());
                compoundtag.remove("Dimension");
                ListTag posTag = new ListTag();
                posTag.add((Object)DoubleTag.valueOf((double)x));
                posTag.add((Object)DoubleTag.valueOf((double)y));
                posTag.add((Object)DoubleTag.valueOf((double)z));
                compoundtag.put("Pos", (Tag)posTag);
                ListTag rotationTag = new ListTag();
                rotationTag.add((Object)FloatTag.valueOf((float)yaw));
                rotationTag.add((Object)FloatTag.valueOf((float)pitch));
                compoundtag.put("Rotation", (Tag)rotationTag);
                entity.load(compoundtag);
                oldEntity.remove(Entity.RemovalReason.CHANGED_DIMENSION);
                level.addDuringTeleport(entity);
            }
        }
        if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).isFallFlying()) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            entity.setOnGround(true);
        }
        return entity;
    }
}

