/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world;

import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.world.gen.LandChunkGenerator;
import com.mraof.minestuck.world.lands.LandTypeExtensions;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.Objects;
import net.commoble.infiniverse.api.InfiniverseAPI;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class DynamicDimensions {
    public static final ResourceKey<DimensionType> LAND_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"land"));
    private static final ResourceLocation LAND_BASE_ID = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"land");

    public static ResourceLocation landIdBaseForPLayer(PlayerIdentifier player) {
        ResourceLocation dimensionName = ResourceLocation.tryBuild((String)"minestuck", (String)("land_" + player.getUsername().toLowerCase()));
        return Objects.requireNonNullElse(dimensionName, LAND_BASE_ID);
    }

    public static ResourceKey<Level> createLand(MinecraftServer server, ResourceLocation baseName, LandTypePair landTypes) {
        ResourceKey<Level> worldKey = DynamicDimensions.findUnusedWorldKey(server, baseName);
        InfiniverseAPI.get().getOrCreateLevel(server, worldKey, () -> {
            RandomSource random = WorldgenRandom.Algorithm.XOROSHIRO.newInstance(server.getWorldData().worldGenOptions().seed()).forkPositional().fromHashOf(worldKey.location());
            LandTypePair.Named named = landTypes.createNamedRandomly(random.fork());
            RegistryAccess.Frozen registryAccess = server.registryAccess();
            LandChunkGenerator chunkGenerator = LandChunkGenerator.create((HolderGetter<NormalNoise.NoiseParameters>)registryAccess.lookupOrThrow(Registries.NOISE), (HolderGetter<DensityFunction>)registryAccess.lookupOrThrow(Registries.DENSITY_FUNCTION), (HolderGetter<Structure>)registryAccess.lookupOrThrow(Registries.STRUCTURE), named, (HolderGetter<Biome>)registryAccess.lookupOrThrow(Registries.BIOME), (HolderGetter<PlacedFeature>)registryAccess.lookupOrThrow(Registries.PLACED_FEATURE), registryAccess.lookupOrThrow(Registries.CONFIGURED_CARVER));
            chunkGenerator.tryInit(LandTypeExtensions.get());
            Holder.Reference dimensionType = registryAccess.lookupOrThrow(Registries.DIMENSION_TYPE).getOrThrow(LAND_TYPE);
            return new LevelStem((Holder)dimensionType, (ChunkGenerator)chunkGenerator);
        });
        return worldKey;
    }

    private static ResourceKey<Level> findUnusedWorldKey(MinecraftServer server, ResourceLocation baseName) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)baseName);
        int i = 0;
        while (server.getLevel(key) != null) {
            key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)baseName.getNamespace(), (String)(baseName.getPath() + "_" + i)));
            ++i;
        }
        return key;
    }
}

