/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.SburbConnections;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.util.Teleport;
import com.mraof.minestuck.world.gen.structure.gate.LandGatePlacement;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GateHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DESTROYED = "minestuck.gate_destroyed";
    public static final int GATE_HEIGHT_1 = 124;
    public static final int GATE_HEIGHT_2 = 154;

    public static void teleport(Type gateType, ServerLevel level, ServerPlayer player) {
        player.setPortalCooldown();
        GlobalPos destination = gateType.getDestination(level);
        if (destination != null) {
            BlockState block;
            ServerLevel destinationWorld = player.server.getLevel(destination.dimension());
            if (gateType.isDestinationGate && !(block = destinationWorld.getBlockState(destination.pos())).is((Block)MSBlocks.GATE_MAIN.get())) {
                LOGGER.debug("Can't find destination gate at {}. Probably broken.", (Object)destination);
                player.sendSystemMessage((Component)Component.translatable((String)DESTROYED));
                return;
            }
            Teleport.teleportEntity((Entity)player, destinationWorld, (double)destination.pos().getX() + 0.5, destination.pos().getY(), (double)destination.pos().getZ() + 0.5);
        }
    }

    private static GlobalPos findPosNearLandGate(ServerLevel level) {
        BlockPos pos = Type.LAND_GATE.getPosition(level);
        if (pos != null) {
            int z;
            int x;
            BlockPos placement;
            RandomSource rand = level.random;
            do {
                int radius = 160 + rand.nextInt(60);
                double d = rand.nextDouble();
                int i = radius * radius;
                x = (int)Math.sqrt((double)i * d);
                z = (int)Math.sqrt((double)i * (1.0 - d));
                if (rand.nextBoolean()) {
                    x = -x;
                }
                if (!rand.nextBoolean()) continue;
                z = -z;
            } while (!level.getBiome(placement = pos.offset(x, 0, z)).is(MSTags.Biomes.LAND_NORMAL));
            int y = level.getChunk(placement).getHeight(Heightmap.Types.MOTION_BLOCKING, placement.getX(), placement.getZ());
            return GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)new BlockPos(placement.getX(), y + 1, placement.getZ()));
        }
        LOGGER.error("Unexpected error: Couldn't find position for land gate for dimension {}.", (Object)level.dimension());
        return null;
    }

    private static GlobalPos findClientLandGate(ServerLevel level) {
        Optional<PlayerIdentifier> landPlayer = SburbPlayerData.getForLand(level).map(SburbPlayerData::playerId);
        if (landPlayer.isEmpty()) {
            LOGGER.error("Unexpected error: Can't find player for land {}!", (Object)level.dimension());
            return null;
        }
        Optional clientLandOptional = SburbConnections.get(level.getServer()).primaryPartnerForServer(landPlayer.get()).flatMap(clientPlayer -> {
            SburbPlayerData clientPlayerData = SburbPlayerData.get(clientPlayer, level.getServer());
            return Optional.ofNullable(clientPlayerData.getLandDimensionIfEntered());
        });
        if (clientLandOptional.isEmpty()) {
            return null;
        }
        ResourceKey clientLand = (ResourceKey)clientLandOptional.get();
        ServerLevel clientLevel = level.getServer().getLevel(clientLand);
        BlockPos gatePos = Type.LAND_GATE.getPosition(clientLevel);
        if (gatePos == null) {
            LOGGER.error("Unexpected error: Can't initialize land gate placement for dimension {}!", (Object)clientLand);
            return null;
        }
        return GlobalPos.of((ResourceKey)clientLand, (BlockPos)gatePos);
    }

    private static GlobalPos findServerSecondGate(ServerLevel level) {
        Optional<PlayerIdentifier> landPlayer = SburbPlayerData.getForLand(level).map(SburbPlayerData::playerId);
        if (landPlayer.isEmpty()) {
            LOGGER.error("Unexpected error: Can't find player for land {}!", (Object)level.dimension());
            return null;
        }
        Optional serverLandOptional = SburbConnections.get(level.getServer()).primaryPartnerForClient(landPlayer.get()).flatMap(serverPlayer -> {
            SburbPlayerData serverPlayerData = SburbPlayerData.get(serverPlayer, level.getServer());
            return Optional.ofNullable(serverPlayerData.getLandDimensionIfEntered());
        });
        if (serverLandOptional.isEmpty()) {
            return null;
        }
        ResourceKey serverLand = (ResourceKey)serverLandOptional.get();
        return GlobalPos.of((ResourceKey)serverLand, (BlockPos)Type.GATE_2.getPosition(level.getServer().getLevel(serverLand)));
    }

    public static enum Type {
        GATE_1(false, world -> new BlockPos(0, 124, 0), GateHandler::findPosNearLandGate),
        GATE_2(true, world -> new BlockPos(0, 154, 0), GateHandler::findClientLandGate),
        LAND_GATE(true, LandGatePlacement::findLandGatePos, GateHandler::findServerSecondGate);

        private final boolean isDestinationGate;
        private final Function<ServerLevel, BlockPos> locationFinder;
        private final Function<ServerLevel, GlobalPos> destinationFinder;

        private Type(boolean isDestinationGate, Function<ServerLevel, BlockPos> locationFinder, Function<ServerLevel, GlobalPos> destinationFinder) {
            this.isDestinationGate = isDestinationGate;
            this.locationFinder = locationFinder;
            this.destinationFinder = destinationFinder;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static Type fromString(String str) {
            for (Type type : Type.values()) {
                if (!type.toString().equals(str)) continue;
                return type;
            }
            return null;
        }

        public GlobalPos getDestination(ServerLevel level) {
            return this.destinationFinder.apply(level);
        }

        public BlockPos getPosition(ServerLevel level) {
            return this.locationFinder.apply(level);
        }
    }
}

