/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world;

import com.google.common.collect.ImmutableMap;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.network.LandTypesDataPacket;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public class MSDimensions {
    public static ResourceKey<Level> SKAIA = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)Minestuck.id("skaia"));
    public static ResourceKey<Level> PROSPIT = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)Minestuck.id("prospit"));
    public static ResourceKey<Level> DERSE = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)Minestuck.id("derse"));
    public static ResourceKey<Level> VEIL = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)Minestuck.id("veil"));
    public static final ResourceLocation LAND_EFFECTS = Minestuck.id("land");
    public static final ResourceLocation PROSPIT_EFFECTS = Minestuck.id("prospit_effects");
    public static final ResourceLocation DERSE_EFFECTS = Minestuck.id("derse_effects");
    public static final ResourceLocation VEIL_EFFECTS = Minestuck.id("veil_effects");

    public static boolean isLandDimension(MinecraftServer server, ResourceKey<Level> levelKey) {
        if (server != null) {
            return LandTypePair.getNamed(server, levelKey).isPresent();
        }
        return false;
    }

    public static boolean isSkaia(ResourceKey<Level> dimension) {
        return dimension == SKAIA;
    }

    public static boolean isProspit(ResourceKey<Level> dimension) {
        return dimension == PROSPIT;
    }

    public static boolean isDerse(ResourceKey<Level> dimension) {
        return dimension == DERSE;
    }

    public static boolean isVeil(ResourceKey<Level> dimension) {
        return dimension == VEIL;
    }

    public static boolean isInMedium(MinecraftServer server, ResourceKey<Level> dimension) {
        return MSDimensions.isLandDimension(server, dimension) || MSDimensions.isSkaia(dimension) || MSDimensions.isVeil(dimension);
    }

    public static void sendLandTypesToAll(MinecraftServer server) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)MSDimensions.createLandTypesPacket(server), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)MSDimensions.createLandTypesPacket(player.server), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static LandTypesDataPacket createLandTypesPacket(MinecraftServer server) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ResourceKey levelKey : server.levelKeys()) {
            LandTypePair.getTypes(server, (ResourceKey<Level>)levelKey).ifPresent(landTypes -> builder.put((Object)levelKey, landTypes));
        }
        return new LandTypesDataPacket((Map<ResourceKey<Level>, LandTypePair>)builder.build());
    }
}

