/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.biome;

import com.mraof.minestuck.world.biome.LandBiome;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public final class LandBiomeSetType {
    public final ResourceKey<Biome> NORMAL;
    public final ResourceKey<Biome> ROUGH;
    public final ResourceKey<Biome> OCEAN;
    private final boolean hasPrecipitation;
    private final float temperature;
    private final float downfall;

    public LandBiomeSetType(String mod, String name, boolean hasPrecipitation, float temperature, float downfall) {
        this.hasPrecipitation = hasPrecipitation;
        this.temperature = temperature;
        this.downfall = downfall;
        this.NORMAL = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)mod, (String)("land_" + name + "_normal")));
        this.ROUGH = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)mod, (String)("land_" + name + "_rough")));
        this.OCEAN = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)mod, (String)("land_" + name + "_ocean")));
    }

    public void createForDataGen(BootstrapContext<Biome> context) {
        context.register(this.NORMAL, (Object)LandBiome.createNormalBiome(this.hasPrecipitation, this.temperature, this.downfall));
        context.register(this.ROUGH, (Object)LandBiome.createRoughBiome(this.hasPrecipitation, this.temperature, this.downfall));
        context.register(this.OCEAN, (Object)LandBiome.createOceanBiome(this.hasPrecipitation, this.temperature, this.downfall));
    }

    public boolean hasPrecipitation() {
        return this.hasPrecipitation;
    }

    public float getTemperature() {
        return this.temperature;
    }
}

