/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.biome;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.world.biome.LandBiomeAccess;
import com.mraof.minestuck.world.gen.LandGenSettings;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public final class LandBiomeSource
extends BiomeSource {
    public static final MapCodec<LandBiomeSource> CODEC = Codec.of((Encoder)Encoder.error((String)"LandBiomeProvider is not serializable."), (Decoder)Decoder.error((String)"LandBiomeProvider is not serializable.")).fieldOf("source");
    private final LandBiomeAccess biomes;
    private final Climate.ParameterList<Holder<Biome>> parameters;

    public LandBiomeSource(LandBiomeAccess biomes, LandGenSettings settings) {
        this.biomes = biomes;
        this.parameters = settings.createBiomeParameters(biomes);
    }

    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return this.biomes.getAll().stream();
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler) {
        return (Holder)this.parameters.findValue(sampler.sample(x, y, z));
    }

    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }
}

