/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.biome;

import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.biome.RegistryBackedBiomeSet;
import com.mraof.minestuck.world.gen.LandGenSettings;
import com.mraof.minestuck.world.gen.feature.FeatureModifier;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.lands.LandBiomeGenBuilder;
import com.mraof.minestuck.world.lands.LandTypeExtensions;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public final class LandCustomBiomeSettings {
    private final BiomeProperties normalBiome;
    private final BiomeProperties oceanBiome;
    private final BiomeProperties roughBiome;
    public final RegistryBackedBiomeSet baseBiomes;

    public LandCustomBiomeSettings(RegistryBackedBiomeSet biomes, LandGenSettings settings, LandTypeExtensions extensions, HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        StructureBlockRegistry blocks = settings.getBlockRegistry();
        LandTypePair landTypes = settings.getLandTypes();
        this.baseBiomes = biomes;
        GenerationBuilder generationBuilder = new GenerationBuilder(features, carvers);
        LandCustomBiomeSettings.addBiomeGeneration(generationBuilder, blocks, landTypes, extensions);
        this.normalBiome = LandCustomBiomeSettings.createBiomeProperties(generationBuilder, extensions, landTypes, LandBiomeType.NORMAL);
        this.roughBiome = LandCustomBiomeSettings.createBiomeProperties(generationBuilder, extensions, landTypes, LandBiomeType.ROUGH);
        this.oceanBiome = LandCustomBiomeSettings.createBiomeProperties(generationBuilder, extensions, landTypes, LandBiomeType.OCEAN);
    }

    public BiomeProperties propertiesFor(Holder<Biome> biome) {
        return switch (this.baseBiomes.getTypeFromBiome(biome)) {
            default -> throw new MatchException(null, null);
            case LandBiomeType.NORMAL -> this.normalBiome;
            case LandBiomeType.ROUGH -> this.roughBiome;
            case LandBiomeType.OCEAN -> this.oceanBiome;
        };
    }

    public BiomeGenerationSettings generationFor(Holder<Biome> baseBiome) {
        return this.propertiesFor(baseBiome).generationSettings();
    }

    public MobSpawnSettings customMobSpawnsFor(Holder<Biome> baseBiome) {
        return this.propertiesFor(baseBiome).mobSettings();
    }

    private static BiomeProperties createBiomeProperties(GenerationBuilder generationBuilder, LandTypeExtensions extensions, LandTypePair landTypes, LandBiomeType type) {
        BiomeGenerationSettings generationSettings = generationBuilder.settings.get((Object)type).build();
        MobSpawnSettings spawnSettings = LandCustomBiomeSettings.createMobSpawnInfo(extensions, landTypes, type);
        return new BiomeProperties(generationSettings, spawnSettings);
    }

    private static MobSpawnSettings createMobSpawnInfo(LandTypeExtensions extensions, LandTypePair landTypes, LandBiomeType type) {
        MobSpawnSettings.Builder builder = new MobSpawnSettings.Builder();
        builder.addSpawn(MSEntityTypes.CONSORT, new MobSpawnSettings.SpawnerData(landTypes.getTerrain().getConsortType(), 2, 1, 3));
        landTypes.getTerrain().setSpawnInfo(builder, type);
        landTypes.getTitle().setSpawnInfo(builder, type);
        extensions.addMobSpawnExtensions(builder, type, landTypes);
        return builder.build();
    }

    private static void addBiomeGeneration(LandBiomeGenBuilder builder, StructureBlockRegistry blocks, LandTypePair landTypes, LandTypeExtensions extensions) {
        builder.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MSPlacedFeatures.RETURN_NODE, LandBiomeType.anyExcept(LandBiomeType.OCEAN));
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), blocks.getBlockState("cruxite_ore"), 6), new PlacementModifier[]{CountPlacement.of((int)21), InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)128)), BiomeFilter.biome()}), LandBiomeType.any());
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, MSPlacedFeatures.inline(Feature.ORE, new OreConfiguration(blocks.getGroundType(), blocks.getBlockState("uranium_ore"), 5), new PlacementModifier[]{CountPlacement.of((int)13), InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-60), (VerticalAnchor)VerticalAnchor.aboveBottom((int)96)), BiomeFilter.biome()}), LandBiomeType.any());
        landTypes.getTerrain().addBiomeGeneration(builder, blocks);
        landTypes.getTitle().addBiomeGeneration(builder, blocks, landTypes.getTerrain().getBiomeSet());
        extensions.addBiomeGenExtensions(builder, landTypes);
    }

    private static class GenerationBuilder
    implements LandBiomeGenBuilder {
        private final HolderGetter<PlacedFeature> features;
        private final Map<LandBiomeType, BiomeGenerationSettings.Builder> settings = new EnumMap<LandBiomeType, BiomeGenerationSettings.Builder>(LandBiomeType.class);

        private GenerationBuilder(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
            this.features = features;
            for (LandBiomeType type : LandBiomeType.values()) {
                this.settings.put(type, new BiomeGenerationSettings.Builder(features, carvers));
            }
        }

        @Override
        public void addFeature(GenerationStep.Decoration step, Holder<PlacedFeature> feature, @Nullable FeatureModifier modifier, LandBiomeType ... types) {
            if (modifier != null) {
                feature = modifier.map(feature);
            }
            for (LandBiomeType type : types) {
                this.settings.get((Object)type).addFeature(step, feature);
            }
        }

        @Override
        public void addFeature(GenerationStep.Decoration step, ResourceKey<PlacedFeature> feature, @Nullable FeatureModifier modifier, LandBiomeType ... types) {
            this.addFeature(step, (Holder<PlacedFeature>)this.features.getOrThrow(feature), modifier, types);
        }

        @Override
        public void addCarver(GenerationStep.Carving step, ResourceKey<ConfiguredWorldCarver<?>> carver, LandBiomeType ... types) {
            for (LandBiomeType type : types) {
                this.settings.get((Object)type).addCarver(step, carver);
            }
        }

        @Override
        public void addCarver(GenerationStep.Carving step, Holder<ConfiguredWorldCarver<?>> carver, LandBiomeType ... types) {
            for (LandBiomeType type : types) {
                this.settings.get((Object)type).addCarver(step, carver);
            }
        }
    }

    public record BiomeProperties(BiomeGenerationSettings generationSettings, MobSpawnSettings mobSettings) {
    }
}

