/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.biome;

import com.google.common.collect.ImmutableList;
import com.mraof.minestuck.world.biome.LandBiomeAccess;
import com.mraof.minestuck.world.biome.LandBiomeSetType;
import com.mraof.minestuck.world.biome.LandBiomeType;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.world.level.biome.Biome;

public final class RegistryBackedBiomeSet
implements LandBiomeAccess {
    public final Holder.Reference<Biome> NORMAL;
    public final Holder.Reference<Biome> ROUGH;
    public final Holder.Reference<Biome> OCEAN;

    public RegistryBackedBiomeSet(LandBiomeSetType biomes, HolderGetter<Biome> registry) {
        this.NORMAL = registry.getOrThrow(biomes.NORMAL);
        this.ROUGH = registry.getOrThrow(biomes.ROUGH);
        this.OCEAN = registry.getOrThrow(biomes.OCEAN);
    }

    @Override
    public List<Holder<Biome>> getAll() {
        return ImmutableList.of(this.NORMAL, this.ROUGH, this.OCEAN);
    }

    @Override
    public Holder<Biome> fromType(LandBiomeType type) {
        switch (type) {
            default: {
                return this.NORMAL;
            }
            case ROUGH: {
                return this.ROUGH;
            }
            case OCEAN: 
        }
        return this.OCEAN;
    }

    public LandBiomeType getTypeFromBiome(Holder<Biome> biome) {
        if (biome == this.NORMAL) {
            return LandBiomeType.NORMAL;
        }
        if (biome == this.ROUGH) {
            return LandBiomeType.ROUGH;
        }
        if (biome == this.OCEAN) {
            return LandBiomeType.OCEAN;
        }
        return LandBiomeType.NORMAL;
    }
}

