/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.util.Lazy;

public abstract class CustomizableNoiseChunkGenerator
extends NoiseBasedChunkGenerator {
    public CustomizableNoiseChunkGenerator(BiomeSource biomeSource, Function<Holder<Biome>, BiomeGenerationSettings> settingsGetter, Holder<NoiseGeneratorSettings> settingsHolder) {
        super(biomeSource, settingsHolder);
        this.setWorldgenSettingsGetter(settingsGetter);
    }

    private void setWorldgenSettingsGetter(Function<Holder<Biome>, BiomeGenerationSettings> settingsGetter) {
        ObfuscationReflectionHelper.setPrivateValue(ChunkGenerator.class, (Object)((Object)this), settingsGetter, (String)"generationSettingsGetter");
        Lazy featuresSupplier = Lazy.of(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(this.getBiomeSource().possibleBiomes()), biome -> this.getBiomeGenerationSettings((Holder)biome).features(), (boolean)true));
        ObfuscationReflectionHelper.setPrivateValue(ChunkGenerator.class, (Object)((Object)this), (Object)featuresSupplier, (String)"featuresPerStep");
    }
}

