/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mraof.minestuck.world.biome.LandBiomeAccess;
import com.mraof.minestuck.world.biome.LandBiomeType;
import com.mraof.minestuck.world.gen.MSDensityFunctions;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import com.mraof.minestuck.world.gen.structure.gate.GateStructure;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class LandGenSettings {
    private final LandTypePair landTypes;
    private final StructureBlockRegistry blockRegistry;
    private GateStructure.PieceFactory gatePiece;
    public float oceanThreshold = -0.2f;
    public float roughThreshold = 0.0f;
    public float oceanOffset = -0.12f;
    public float inlandOffset = 0.12f;
    public float inlandAngle = 0.2f;
    public float oceanFactor = 6.0f;
    public float normalFactor = 5.0f;
    public float roughFactor = 3.0f;

    LandGenSettings(LandTypePair landTypes) {
        this.landTypes = landTypes;
        this.blockRegistry = StructureBlockRegistry.init(landTypes);
        landTypes.getTerrain().setGenSettings(this);
        landTypes.getTitle().setGenSettings(this);
    }

    public LandTypePair getLandTypes() {
        return this.landTypes;
    }

    public StructureBlockRegistry getBlockRegistry() {
        return this.blockRegistry;
    }

    public void setGatePiece(GateStructure.PieceFactory factory) {
        this.gatePiece = factory;
    }

    public GateStructure.PieceFactory getGatePiece() {
        return this.gatePiece;
    }

    Holder<NoiseGeneratorSettings> createDimensionSettings(HolderGetter<NormalNoise.NoiseParameters> noises, HolderGetter<DensityFunction> densityFunctions) {
        NoiseSettings noiseSettings = NoiseSettings.create((int)-64, (int)384, (int)1, (int)2);
        SurfaceRules.RuleSource bedrockFloor = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.BEDROCK.defaultBlockState()));
        SurfaceRules.RuleSource surfaceRule = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{bedrockFloor, this.landTypes.getTerrain().getSurfaceRule(this.blockRegistry)});
        NoiseGeneratorSettings settings = new NoiseGeneratorSettings(noiseSettings, this.blockRegistry.getBlockState("ground"), this.blockRegistry.getBlockState("ocean"), this.makeLandNoiseRouter(noises, densityFunctions), surfaceRule, List.of(), 64, false, true, false, false);
        return Holder.direct((Object)settings);
    }

    public boolean hasOceanTerrain() {
        return (double)this.oceanThreshold > -0.95;
    }

    private float getOceanThreshold(float offset) {
        return this.hasOceanTerrain() ? this.oceanThreshold + offset : -1.0f;
    }

    public boolean hasRoughTerrain() {
        return (double)this.roughThreshold > -0.95;
    }

    private float getRoughThreshold(float offset) {
        return this.hasRoughTerrain() ? this.roughThreshold + offset : -1.0f;
    }

    private NoiseRouter makeLandNoiseRouter(HolderGetter<NormalNoise.NoiseParameters> noises, HolderGetter<DensityFunction> densityFunctions) {
        DensityFunctions.Spline.Coordinate continents = new DensityFunctions.Spline.Coordinate((Holder)densityFunctions.getOrThrow(MSDensityFunctions.LAND_CONTINENTS));
        DensityFunctions.Spline.Coordinate erosion = new DensityFunctions.Spline.Coordinate((Holder)densityFunctions.getOrThrow(MSDensityFunctions.LAND_EROSION));
        DensityFunction depth = MSDensityFunctions.depth(this.offset(continents));
        DensityFunction factor = this.factor(continents, erosion);
        DensityFunction initialDensity = MSDensityFunctions.initialDensity(depth, factor);
        DensityFunction finalDensity = MSDensityFunctions.finalDensity(depth, factor, DensityFunctions.zero(), (Holder<NormalNoise.NoiseParameters>)noises.getOrThrow(Noises.JAGGED), 320, 0.25f);
        return new NoiseRouter(DensityFunctions.zero(), DensityFunctions.constant((double)-1.0), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), MSDensityFunctions.get(densityFunctions, MSDensityFunctions.LAND_CONTINENTS), MSDensityFunctions.get(densityFunctions, MSDensityFunctions.LAND_EROSION), depth, DensityFunctions.zero(), initialDensity, finalDensity, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    private DensityFunction offset(DensityFunctions.Spline.Coordinate continents) {
        CubicSpline.Builder builder = CubicSpline.builder((ToFloatFunction)continents);
        if (this.hasOceanTerrain()) {
            builder.addPoint(this.getOceanThreshold(-0.2f), this.oceanOffset, 0.0f);
        }
        builder.addPoint(this.getOceanThreshold(0.2f), this.inlandOffset, this.inlandAngle);
        return DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.50375), (DensityFunction)DensityFunctions.spline((CubicSpline)builder.build()));
    }

    private DensityFunction factor(DensityFunctions.Spline.Coordinate continents, DensityFunctions.Spline.Coordinate erosion) {
        CubicSpline.Builder inlandBuilder = CubicSpline.builder((ToFloatFunction)erosion);
        if (this.hasRoughTerrain()) {
            inlandBuilder.addPoint(this.getRoughThreshold(-0.05f), this.roughFactor, 0.0f);
        }
        inlandBuilder.addPoint(this.getRoughThreshold(0.05f), this.normalFactor, 0.0f);
        CubicSpline.Builder builder = CubicSpline.builder((ToFloatFunction)continents);
        if (this.hasOceanTerrain()) {
            builder.addPoint(this.getOceanThreshold(-0.1f), this.oceanFactor, 0.0f);
        }
        builder.addPoint(this.getOceanThreshold(0.1f), inlandBuilder.build());
        return DensityFunctions.spline((CubicSpline)builder.build());
    }

    public Climate.ParameterList<Holder<Biome>> createBiomeParameters(LandBiomeAccess biomes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.hasOceanTerrain()) {
            builder.add((Object)Pair.of((Object)LandGenSettings.simpleParameterPoint(Climate.Parameter.span((float)-1.0f, (float)this.getOceanThreshold(0.0f)), Climate.Parameter.span((float)-1.0f, (float)1.0f)), biomes.fromType(LandBiomeType.OCEAN)));
        }
        Climate.Parameter inlandContinentalness = Climate.Parameter.span((float)this.getOceanThreshold(0.0f), (float)1.0f);
        if (this.hasRoughTerrain()) {
            builder.add((Object)Pair.of((Object)LandGenSettings.simpleParameterPoint(inlandContinentalness, Climate.Parameter.span((float)-1.0f, (float)this.getRoughThreshold(0.0f))), biomes.fromType(LandBiomeType.ROUGH)));
        }
        builder.add((Object)Pair.of((Object)LandGenSettings.simpleParameterPoint(inlandContinentalness, Climate.Parameter.span((float)this.getRoughThreshold(0.0f), (float)1.0f)), biomes.fromType(LandBiomeType.NORMAL)));
        return new Climate.ParameterList((List)builder.build());
    }

    private static Climate.ParameterPoint simpleParameterPoint(Climate.Parameter continents, Climate.Parameter erosion) {
        return Climate.parameters((Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)continents, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (float)0.0f);
    }
}

