/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen;

import com.mojang.datafixers.util.Pair;
import com.mraof.minestuck.util.MSTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LandStructureState
extends ChunkGeneratorStructureState {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BiomeSource biomeSource;
    private ChunkPos landGatePosition;

    public LandStructureState(RandomState randomState, BiomeSource biomeSource, long seed, List<Holder<StructureSet>> possibleStructureSets) {
        super(randomState, biomeSource, seed, seed, possibleStructureSets);
        this.biomeSource = biomeSource;
    }

    public ChunkPos getOrFindLandGatePosition() {
        if (this.landGatePosition == null) {
            this.landGatePosition = LandStructureState.findLandGatePosition(this.biomeSource, this.randomState(), RandomSource.create((long)this.getLevelSeed()));
        }
        return this.landGatePosition;
    }

    private static ChunkPos findLandGatePosition(BiomeSource biomeSource, RandomState randomState, RandomSource worldRand) {
        Pair result;
        int posZ;
        int posX;
        int radius;
        double angle = Math.PI * 2 * worldRand.nextDouble();
        for (radius = 38 + worldRand.nextInt(12); radius < 65; radius += 6) {
            BlockPos pos;
            posX = (int)Math.round(Math.cos(angle) * (double)radius);
            result = biomeSource.findBiomeHorizontal((posX << 4) + 8, 0, ((posZ = (int)Math.round(Math.sin(angle) * (double)radius)) << 4) + 8, 96, biome -> biome.is(MSTags.Biomes.LAND_NORMAL), worldRand, randomState.sampler());
            if (result == null || !biomeSource.getBiomesWithin((pos = (BlockPos)result.getFirst()).getX(), 0, pos.getZ(), 16, randomState.sampler()).stream().allMatch(biome -> biome.is(MSTags.Biomes.LAND_NORMAL))) continue;
            return new ChunkPos(pos);
        }
        posX = (int)Math.round(Math.cos(angle) * (double)radius);
        posZ = (int)Math.round(Math.sin(angle) * (double)radius);
        LOGGER.warn("Did not come across a decent location for land gates. Placing it without regard to any biomes.");
        result = biomeSource.findBiomeHorizontal((posX << 4) + 8, 0, (posZ << 4) + 8, 96, biome -> biome.is(MSTags.Biomes.LAND_NORMAL), worldRand, randomState.sampler());
        if (result != null) {
            return new ChunkPos((BlockPos)result.getFirst());
        }
        return new ChunkPos(posX, posZ);
    }
}

