/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class MSDensityFunctions {
    public static final ResourceKey<DensityFunction> SHIFT_X = MSDensityFunctions.key("shift_x");
    public static final ResourceKey<DensityFunction> SHIFT_Z = MSDensityFunctions.key("shift_z");
    public static final ResourceKey<DensityFunction> SKAIA_RIDGES = MSDensityFunctions.key("skaia/ridges");
    public static final ResourceKey<DensityFunction> SKAIA_OFFSET = MSDensityFunctions.key("skaia/offset");
    public static final ResourceKey<DensityFunction> SKAIA_DEPTH = MSDensityFunctions.key("skaia/depth");
    public static final ResourceKey<DensityFunction> SKAIA_INITIAL_DENSITY = MSDensityFunctions.key("skaia/initial_density");
    public static final ResourceKey<DensityFunction> SKAIA_FINAL_DENSITY = MSDensityFunctions.key("skaia/final_density");
    public static final ResourceKey<DensityFunction> VEIL_RIDGES = MSDensityFunctions.key("veil/ridges");
    public static final ResourceKey<DensityFunction> VEIL_OFFSET = MSDensityFunctions.key("veil/offset");
    public static final ResourceKey<DensityFunction> VEIL_DEPTH = MSDensityFunctions.key("veil/depth");
    public static final ResourceKey<DensityFunction> VEIL_INITIAL_DENSITY = MSDensityFunctions.key("veil/initial_density");
    public static final ResourceKey<DensityFunction> VEIL_FINAL_DENSITY = MSDensityFunctions.key("veil/final_density");
    public static final ResourceKey<DensityFunction> LAND_CONTINENTS = MSDensityFunctions.key("land/continents");
    public static final ResourceKey<DensityFunction> LAND_EROSION = MSDensityFunctions.key("land/erosion");

    private static ResourceKey<DensityFunction> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)name));
    }

    public static DensityFunction depth(DensityFunction offset) {
        return MSDensityFunctions.depth(offset, -64, 320);
    }

    public static DensityFunction depth(DensityFunction offset, int fromY, int toY) {
        return DensityFunctions.add((DensityFunction)DensityFunctions.yClampedGradient((int)fromY, (int)toY, (double)1.5, (double)-1.5), (DensityFunction)offset);
    }

    public static DensityFunction initialDensity(DensityFunction depth, DensityFunction factor) {
        return DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)4.0), (DensityFunction)DensityFunctions.mul((DensityFunction)depth, (DensityFunction)factor).quarterNegative());
    }

    public static DensityFunction finalDensity(DensityFunction depth, DensityFunction factor, DensityFunction jaggedness, Holder<NormalNoise.NoiseParameters> jagged, int height, float xzScale) {
        DensityFunction noise = DensityFunctions.noise(jagged, (double)1500.0, (double)0.0);
        DensityFunction jaggednessFactor = DensityFunctions.mul((DensityFunction)jaggedness, (DensityFunction)noise.halfNegative());
        DensityFunction modifiedDepth = DensityFunctions.add((DensityFunction)depth, (DensityFunction)jaggednessFactor);
        DensityFunction baseDensity = MSDensityFunctions.initialDensity(modifiedDepth, factor);
        BlendedNoise base3dNoise = BlendedNoise.createUnseeded((double)xzScale, (double)0.125, (double)80.0, (double)160.0, (double)8.0);
        return DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)0.64), (DensityFunction)DensityFunctions.interpolated((DensityFunction)DensityFunctions.blendDensity((DensityFunction)MSDensityFunctions.yLerpSlide(height, height - 16, -1.0, MSDensityFunctions.yLerpSlide(-64, -40, 1.0, DensityFunctions.add((DensityFunction)base3dNoise, (DensityFunction)baseDensity)))))).squeeze();
    }

    private static DensityFunction yLerpSlide(int y1, int y2, double fixedValue, DensityFunction density) {
        DensityFunction lerpValue = DensityFunctions.yClampedGradient((int)y1, (int)y2, (double)0.0, (double)1.0);
        return DensityFunctions.lerp((DensityFunction)lerpValue, (double)fixedValue, (DensityFunction)density);
    }

    public static DensityFunction get(HolderGetter<DensityFunction> registry, ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder((Holder)registry.getOrThrow(key));
    }
}

