/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.neoforged.neoforge.registries.DeferredRegister;

@MethodsReturnNonnullByDefault
public final class MSSurfaceRules
extends SurfaceRules {
    public static final DeferredRegister<MapCodec<? extends SurfaceRules.RuleSource>> REGISTER = DeferredRegister.create((ResourceKey)Registries.MATERIAL_RULE, (String)"minestuck");

    static {
        REGISTER.register("checkered", () -> CheckeredRuleSource.CODEC.codec());
    }

    public record CheckeredRuleSource(int squareSize, List<SurfaceRules.RuleSource> rules) implements SurfaceRules.RuleSource
    {
        private static final KeyDispatchDataCodec<CheckeredRuleSource> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("size").forGetter(CheckeredRuleSource::squareSize), (App)SurfaceRules.RuleSource.CODEC.listOf().fieldOf("rules").forGetter(CheckeredRuleSource::rules)).apply((Applicative)instance, CheckeredRuleSource::new)));

        public KeyDispatchDataCodec<CheckeredRuleSource> codec() {
            return CODEC;
        }

        public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
            if (this.rules.size() == 1) {
                return (SurfaceRules.SurfaceRule)this.rules.get(0).apply((Object)context);
            }
            return new CheckeredSurfaceRule(this.squareSize, this.rules.stream().map(ruleSource -> (SurfaceRules.SurfaceRule)ruleSource.apply((Object)context)).toList());
        }
    }

    private record CheckeredSurfaceRule(int squareSize, List<SurfaceRules.SurfaceRule> rules) implements SurfaceRules.SurfaceRule
    {
        @Nullable
        public BlockState tryApply(int x, int y, int z) {
            int size = this.rules.size();
            if (size == 0) {
                return null;
            }
            int squareX = Math.floorDiv(x, this.squareSize);
            int squareZ = Math.floorDiv(z, this.squareSize);
            int ruleIndex = Math.floorMod(squareX - squareZ, size);
            return this.rules.get(ruleIndex).tryApply(x, y, z);
        }
    }
}

