/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mraof.minestuck.world.gen.feature.TemplatePlacement;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class BucketFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceLocation STRUCTURE_BUCKET_0 = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"bucket_0");
    private static final ResourceLocation STRUCTURE_BUCKET_1 = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"bucket_1");
    private static final ResourceLocation STRUCTURE_BUCKET_WITH_HANDLE_0 = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"bucket_with_handle_0");
    private static final ResourceLocation STRUCTURE_BUCKET_WITH_HANDLE_1 = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"bucket_with_handle_1");

    public BucketFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.origin();
        WorldGenLevel level = context.level();
        RandomSource rand = context.random();
        StructureTemplate template = level.getLevel().getStructureManager().getOrCreate(BucketFeature.pickTemplate(rand));
        TemplatePlacement placement = TemplatePlacement.centeredWithRandomRotation(template, pos, rand);
        StructurePlaceSettings settings = new StructurePlaceSettings().addProcessor((StructureProcessor)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.BLUE_STAINED_GLASS), (RuleTest)AlwaysTrueTest.INSTANCE, BucketFeature.pickBucketFluid(context)))));
        placement.placeWithStructureBlockRegistry(context, settings);
        return true;
    }

    private static ResourceLocation pickTemplate(RandomSource rand) {
        if (rand.nextFloat() < 0.6f) {
            return rand.nextFloat() < 0.7f ? STRUCTURE_BUCKET_0 : STRUCTURE_BUCKET_1;
        }
        return rand.nextFloat() < 0.7f ? STRUCTURE_BUCKET_WITH_HANDLE_0 : STRUCTURE_BUCKET_WITH_HANDLE_1;
    }

    private static BlockState pickBucketFluid(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource rand = context.random();
        if (rand.nextBoolean()) {
            StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(context.chunkGenerator());
            return blocks.getBlockState(rand.nextBoolean() ? "ocean" : "river");
        }
        SimpleWeightedRandomList.Builder list = SimpleWeightedRandomList.builder();
        list.add((Object)Blocks.AIR.defaultBlockState(), 50);
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            FluidState fluidState = fluid.defaultFluidState();
            if (!fluidState.isSource()) continue;
            BlockState fluidBlock = fluidState.createLegacyBlock();
            switch (fluid.getFluidType().getRarity()) {
                case COMMON: {
                    list.add((Object)fluidBlock, 50);
                    break;
                }
                case UNCOMMON: {
                    list.add((Object)fluidBlock, 10);
                    break;
                }
                case RARE: {
                    list.add((Object)fluidBlock, 1);
                }
            }
        }
        return (BlockState)list.build().getRandomValue(rand).orElseThrow();
    }
}

