/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class ConditionFreeBlobFeature
extends Feature<BlockStateConfiguration> {
    public ConditionFreeBlobFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        BlockStateConfiguration config = (BlockStateConfiguration)context.config();
        boolean startRadius = false;
        for (int i1 = 0; i1 < 3; ++i1) {
            int xSize = 0 + rand.nextInt(2);
            int ySize = 0 + rand.nextInt(2);
            int zSize = 0 + rand.nextInt(2);
            float f = (float)(xSize + ySize + zSize) * 0.333f + 0.5f;
            Iterator iterator = BlockPos.betweenClosedStream((BlockPos)pos.offset(-xSize, -ySize, -zSize), (BlockPos)pos.offset(xSize, ySize, zSize)).iterator();
            while (iterator.hasNext()) {
                BlockPos blockpos1 = (BlockPos)iterator.next();
                if (!(blockpos1.distSqr((Vec3i)pos) <= (double)(f * f))) continue;
                this.setBlock((LevelWriter)level, blockpos1, config.state);
            }
            pos = pos.offset(-1 + rand.nextInt(2), 0 - rand.nextInt(2), -1 + rand.nextInt(2));
        }
        return true;
    }
}

