/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public interface FeatureModifier {
    public Holder<PlacedFeature> map(Holder<PlacedFeature> var1);

    public static FeatureModifier withTargets(final BlockPredicate targets) {
        return new ConfigMapper(){

            @Override
            public <T extends FeatureConfiguration> Optional<T> maybeMap(T config) {
                if (config instanceof DiskConfiguration) {
                    DiskConfiguration diskConfig = (DiskConfiguration)config;
                    return Optional.of(new DiskConfiguration(diskConfig.stateProvider(), targets, diskConfig.radius(), diskConfig.halfHeight()));
                }
                return this.maybeMapBase(config);
            }
        };
    }

    public static FeatureModifier withState(final BlockState state) {
        return new ConfigMapper(){

            @Override
            public <T extends FeatureConfiguration> Optional<T> maybeMap(T config) {
                if (config.getClass() == BlockStateConfiguration.class) {
                    return Optional.of(new BlockStateConfiguration(state));
                }
                if (config instanceof DiskConfiguration) {
                    DiskConfiguration diskConfig = (DiskConfiguration)config;
                    return Optional.of(new DiskConfiguration(RuleBasedBlockStateProvider.simple((BlockStateProvider)BlockStateProvider.simple((BlockState)state)), diskConfig.target(), diskConfig.radius(), diskConfig.halfHeight()));
                }
                return this.maybeMapBase(config);
            }
        };
    }

    public static interface ConfigMapper
    extends FeatureModifier {
        public <T extends FeatureConfiguration> Optional<T> maybeMap(T var1);

        default public <T extends FeatureConfiguration> Optional<T> maybeMapBase(T config) {
            if (config instanceof RandomFeatureConfiguration) {
                RandomFeatureConfiguration featureConfig = (RandomFeatureConfiguration)config;
                return Optional.of(new RandomFeatureConfiguration(featureConfig.features.stream().map((? super T weighted) -> new WeightedPlacedFeature(this.map((Holder<PlacedFeature>)weighted.feature), weighted.chance)).toList(), this.map((Holder<PlacedFeature>)featureConfig.defaultFeature)));
            }
            return Optional.empty();
        }

        default public Optional<PlacedFeature> maybeMap(PlacedFeature placed) {
            return this.maybeMap((ConfiguredFeature)placed.feature().value()).map((? super T newConfigured) -> new PlacedFeature(Holder.direct((Object)newConfigured), placed.placement()));
        }

        default public <FC extends FeatureConfiguration, F extends Feature<FC>> Optional<ConfiguredFeature<FC, F>> maybeMap(ConfiguredFeature<FC, F> configured) {
            return this.maybeMap(configured.config()).map((? super T newConfig) -> new ConfiguredFeature(configured.feature(), newConfig));
        }

        @Override
        default public Holder<PlacedFeature> map(Holder<PlacedFeature> placedFeature) {
            return this.maybeMap((PlacedFeature)placedFeature.value()).map(Holder::direct).orElse(placedFeature);
        }
    }
}

