/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mraof.minestuck.world.gen.feature.TemplatePlacement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class LargeCakeFeature
extends Feature<NoneFeatureConfiguration> {
    public LargeCakeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private static List<WeightedEntry.Wrapper<ResourceLocation>> buildWeightedList() {
        ArrayList weightedStructureList = Lists.newArrayList();
        weightedStructureList.add(WeightedEntry.wrap((Object)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"large_cake_round"), (int)5));
        weightedStructureList.add(WeightedEntry.wrap((Object)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"large_cake_round_extra_large"), (int)2));
        weightedStructureList.add(WeightedEntry.wrap((Object)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"large_cake_double_layer_round"), (int)1));
        weightedStructureList.add(WeightedEntry.wrap((Object)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"large_cake_eaten"), (int)1));
        weightedStructureList.add(WeightedEntry.wrap((Object)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"large_cake_birthday0"), (int)1));
        weightedStructureList.add(WeightedEntry.wrap((Object)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"large_cake_birthday1"), (int)1));
        weightedStructureList.add(WeightedEntry.wrap((Object)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"large_cake_birthday2"), (int)1));
        return weightedStructureList;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource rand = context.random();
        ResourceLocation templateId = (ResourceLocation)((WeightedEntry.Wrapper)WeightedRandom.getRandomItem((RandomSource)rand, LargeCakeFeature.buildWeightedList()).orElseThrow()).data();
        StructureTemplate template = level.getLevel().getStructureManager().getOrCreate(templateId);
        TemplatePlacement placement = TemplatePlacement.centeredWithRandomRotation(template, context.origin(), rand);
        int y = Math.max(0, placement.minHeight(Heightmap.Types.WORLD_SURFACE_WG, (LevelReader)level) - rand.nextInt(1));
        placement.placeWithStructureBlockRegistryAt(y, context);
        return true;
    }
}

