/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.util.CoordPair;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class MesaFeature
extends Feature<NoneFeatureConfiguration> {
    private final BlockState[] baseBlock = new BlockState[]{Blocks.RED_TERRACOTTA.defaultBlockState(), Blocks.ORANGE_TERRACOTTA.defaultBlockState(), Blocks.YELLOW_TERRACOTTA.defaultBlockState(), Blocks.GREEN_TERRACOTTA.defaultBlockState(), Blocks.CYAN_TERRACOTTA.defaultBlockState(), Blocks.BLUE_TERRACOTTA.defaultBlockState(), Blocks.PURPLE_TERRACOTTA.defaultBlockState(), Blocks.MAGENTA_TERRACOTTA.defaultBlockState()};
    private final BlockState[] altBlock = new BlockState[]{Blocks.RED_GLAZED_TERRACOTTA.defaultBlockState(), Blocks.ORANGE_GLAZED_TERRACOTTA.defaultBlockState(), Blocks.YELLOW_GLAZED_TERRACOTTA.defaultBlockState(), Blocks.GREEN_GLAZED_TERRACOTTA.defaultBlockState(), Blocks.CYAN_GLAZED_TERRACOTTA.defaultBlockState(), Blocks.BLUE_GLAZED_TERRACOTTA.defaultBlockState(), Blocks.PURPLE_GLAZED_TERRACOTTA.defaultBlockState(), Blocks.MAGENTA_GLAZED_TERRACOTTA.defaultBlockState()};
    private final BlockState baseCore = Blocks.AIR.defaultBlockState();
    private final BlockState altCore = Blocks.BEACON.defaultBlockState();
    private final boolean stomps = false;

    public MesaFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int tallness;
        RandomSource rand;
        int height;
        BlockPos pos;
        WorldGenLevel level = context.level();
        if (!level.getFluidState((pos = context.origin()).above((height = (rand = context.random()).nextInt(tallness = 7) + tallness + 3) * 2 / 3)).isEmpty()) {
            return false;
        }
        float plateauSize = 0.6f + rand.nextFloat() * ((float)height / 10.0f);
        float altFrequency = 0.01f;
        boolean isAlt = rand.nextFloat() < altFrequency;
        StructureBlockRegistry blocks = StructureBlockRegistry.getOrDefault(context.chunkGenerator());
        BlockPos nodePos = this.generateMesa(pos.above(height), height, plateauSize, (LevelAccessor)level, rand, isAlt, blocks.getBlockState("ground"));
        level.setBlock(nodePos, isAlt ? this.altCore : this.baseCore, 2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private BlockPos generateMesa(BlockPos rockPos, int height, float plateauSize, LevelAccessor level, RandomSource random, boolean isAlt, BlockState groundBlock) {
        BlockPos pos;
        BoundingBox boundingBox = new BoundingBox(rockPos.getX() - 8, level.getMinBuildHeight(), rockPos.getZ() - 8, rockPos.getX() + 7, level.getMaxBuildHeight(), rockPos.getZ() + 7);
        float xSlope = random.nextFloat();
        float zSlope = random.nextFloat();
        HashMap<CoordPair, Integer> heightMap = new HashMap<CoordPair, Integer>();
        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
        HashMap<BlockPos, BlockState> was = new HashMap<BlockPos, BlockState>();
        toProcess.add(rockPos);
        toProcess.add(null);
        while (!toProcess.isEmpty()) {
            CoordPair xz;
            BlockPos pos2 = (BlockPos)toProcess.remove();
            if (pos2 == null) {
                if (toProcess.isEmpty()) break;
                plateauSize = (float)((double)plateauSize - 0.25);
                toProcess.add(null);
                continue;
            }
            if (!boundingBox.isInside((Vec3i)pos2)) continue;
            if (random.nextFloat() * xSlope < plateauSize) {
                toProcess.add(pos2.west());
            }
            if (random.nextFloat() * (1.0f - xSlope) < plateauSize) {
                toProcess.add(pos2.east());
            }
            if (random.nextFloat() * zSlope < plateauSize) {
                toProcess.add(pos2.north());
            }
            if (random.nextFloat() * (1.0f - zSlope) < plateauSize) {
                toProcess.add(pos2.south());
            }
            if (heightMap.containsKey(xz = new CoordPair(pos2.getX(), pos2.getZ()))) continue;
            heightMap.put(xz, pos2.getY());
        }
        LinkedList<Object> toProcess2 = new LinkedList<Object>();
        int h = 1;
        for (CoordPair coordPair : heightMap.keySet()) {
            if (!MesaFeature.checkCoord(coordPair, heightMap)) continue;
            toProcess2.add(new BlockEntry(coordPair, plateauSize + 0.2f));
        }
        toProcess2.add(null);
        while (!toProcess2.isEmpty()) {
            BlockEntry entry = (BlockEntry)toProcess2.remove();
            if (entry == null) {
                ++h;
                if (toProcess2.isEmpty()) break;
                toProcess2.add(null);
                continue;
            }
            if (!boundingBox.isInside((Vec3i)entry.pos.atY(64)) || !MesaFeature.checkCoord(entry.pos, heightMap)) continue;
            if (random.nextFloat() < entry.spreadChance) {
                void var17_22;
                if (random.nextBoolean()) {
                    CoordPair coordPair = random.nextFloat() < xSlope ? entry.pos.east() : entry.pos.west();
                } else {
                    CoordPair coordPair = random.nextFloat() < zSlope ? entry.pos.south() : entry.pos.north();
                }
                entry.spreadChance -= Math.min(0.5f, 2.0f * (float)h / (float)height);
                if (!heightMap.containsKey(var17_22)) {
                    pos = var17_22.atY(rockPos.getY() - h);
                    heightMap.put((CoordPair)var17_22, pos.getY());
                    if (MesaFeature.checkCoord((CoordPair)var17_22, heightMap)) {
                        toProcess2.add(new BlockEntry((CoordPair)var17_22, entry.spreadChance));
                    }
                }
            } else {
                entry.spreadChance += 0.5f;
            }
            if (level.getBlockState(entry.pos.atY(rockPos.getY() - h - 1)).equals(groundBlock)) continue;
            toProcess2.add(entry);
        }
        for (Map.Entry entry : heightMap.entrySet()) {
            pos = ((CoordPair)entry.getKey()).atY((Integer)entry.getValue());
            do {
                was.put(pos, level.getBlockState(pos));
                level.setBlock(pos, isAlt ? this.altBlock[pos.getY() % this.altBlock.length] : this.baseBlock[pos.getY() % this.baseBlock.length], 2);
            } while (!level.getBlockState(pos = pos.below()).equals(groundBlock));
        }
        CoordPair nodePos = new CoordPair(rockPos.getX(), rockPos.getZ());
        boolean bl = false;
        for (int i = 0; i < 9; ++i) {
            int n;
            CoordPair coords = new CoordPair(rockPos.getX() + i % 3 - 1, rockPos.getZ() + i / 3 - 1);
            int blockCount = 0;
            for (int i1 = 0; i1 < 4; ++i1) {
                Integer coordsHeight = (Integer)heightMap.get(new CoordPair(coords.x() + i1 % 2, coords.z() + i1 / 2));
                if (coordsHeight == null || coordsHeight.intValue() != rockPos.getY()) continue;
                ++blockCount;
            }
            if (blockCount <= n) continue;
            nodePos = coords;
            n = blockCount;
        }
        BlockPos corePosition = nodePos.atY(rockPos.getY() + 1);
        return corePosition;
    }

    private static boolean checkCoord(CoordPair pair, Map<CoordPair, Integer> map) {
        return !map.containsKey(pair.north()) || !map.containsKey(pair.east()) || !map.containsKey(pair.south()) || !map.containsKey(pair.west());
    }

    private static /* synthetic */ void lambda$generateMesa$0(LevelAccessor level, BlockPos t, BlockState u) {
        level.setBlock(t, u, 2);
    }

    private static class BlockEntry {
        private final CoordPair pos;
        private float spreadChance;

        private BlockEntry(CoordPair pos, float spreadChance) {
            this.pos = pos;
            this.spreadChance = spreadChance;
        }
    }
}

