/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class OasisFeature
extends Feature<NoneFeatureConfiguration> {
    public OasisFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int x;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        boolean[] blocks = new boolean[1024];
        int runthroughs = rand.nextInt(3) + 4;
        for (int i = 0; i < runthroughs; ++i) {
            double xSize = rand.nextDouble() * 5.0 + 5.0;
            double ySize = rand.nextDouble() * 4.0 + 3.0;
            double zSize = rand.nextDouble() * 5.0 + 5.0;
            double xPos = rand.nextDouble() * (16.0 - xSize - 4.0) + 2.0 + xSize / 2.0;
            double yPos = rand.nextDouble() * (5.0 - ySize / 2.0 - 2.0) + 2.0 + ySize / 2.0;
            double zPos = rand.nextDouble() * (16.0 - zSize - 4.0) + 2.0 + zSize / 2.0;
            for (x = 2; x < 14; ++x) {
                for (int z = 2; z < 14; ++z) {
                    for (int y = 1; y < 4; ++y) {
                        double xDiff = ((double)x - xPos) / (xSize / 2.0);
                        double yDiff = ((double)y - yPos) / (ySize / 2.0);
                        double zDiff = ((double)z - zPos) / (zSize / 2.0);
                        double distance = xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
                        if (!(distance < 1.0)) continue;
                        blocks[(x * 16 + z) * 4 + y] = true;
                    }
                }
            }
        }
        int yMin = level.getMaxBuildHeight();
        int yMax = level.getMinBuildHeight();
        for (int x2 = 1; x2 < 15; ++x2) {
            for (int z = 1; z < 15; ++z) {
                if (blocks[(x2 * 16 + z) * 4 + 3] || !this.hasBlock1(blocks, x2, 3, z, true)) continue;
                BlockPos topPos = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pos.offset(x2 - 8, 0, z - 8)).below();
                yMin = Math.min(yMin, topPos.getY());
                yMax = Math.max(yMax, topPos.getY());
            }
        }
        if (yMax - yMin > 1) {
            return false;
        }
        pos = pos.above(yMin - pos.getY());
        BlockPos treePos = null;
        int blockCount = 0;
        for (int x3 = 0; x3 < 16; ++x3) {
            for (int z = 0; z < 16; ++z) {
                int y;
                for (y = 0; y < 4; ++y) {
                    int index = (x3 * 16 + z) * 4 + y;
                    if (blocks[index]) {
                        this.setBlock((LevelWriter)level, pos.offset(x3 - 8, y - 3, z - 8), Blocks.WATER.defaultBlockState());
                        continue;
                    }
                    if (blocks[index] || !this.hasBlock1(blocks, x3, y, z, false)) continue;
                    this.setBlock((LevelWriter)level, pos.offset(x3 - 8, y - 3, z - 8), Blocks.DIRT.defaultBlockState());
                }
                if (!blocks[(x3 * 16 + z) * 4 + 3] && this.hasBlock2(blocks, x3, 3, z)) {
                    BlockPos surfacePos = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, pos.offset(x3 - 8, 0, z - 8));
                    this.setBlock((LevelWriter)level, surfacePos.below(), Blocks.GRASS_BLOCK.defaultBlockState());
                    if (rand.nextInt(5) == 0) {
                        this.setBlock((LevelWriter)level, surfacePos, Blocks.SHORT_GRASS.defaultBlockState());
                    }
                    if (!this.hasBlock1(blocks, x3, 3, z, true) || rand.nextInt(++blockCount) != 0) continue;
                    treePos = surfacePos;
                    continue;
                }
                if (!blocks[(x3 * 16 + z) * 4 + 3]) continue;
                for (y = 0; y < 4; ++y) {
                    this.setBlock((LevelWriter)level, pos.offset(x3 - 8, y + 1, z - 8), Blocks.AIR.defaultBlockState());
                }
            }
        }
        if (treePos != null) {
            int posX = treePos.getX() + 8 - pos.getX();
            int posZ = treePos.getZ() + 8 - pos.getZ();
            int topX = Math.max(4, Math.min(11, posX - 2 + rand.nextInt(3)));
            int topZ = Math.max(4, Math.min(11, posZ - 2 + rand.nextInt(3)));
            BlockPos topPos = pos.offset(topX - 8, treePos.getY() - pos.getY() + 5 + rand.nextInt(2), topZ - 8);
            BlockState log = Blocks.JUNGLE_LOG.defaultBlockState();
            BlockState leaves = Blocks.JUNGLE_LEAVES.defaultBlockState();
            BlockPos diff = topPos.subtract((Vec3i)treePos);
            int logChecks = 12;
            for (int i = 0; i <= logChecks; ++i) {
                BlockPos currentPos = treePos.offset(diff.getX() * i / logChecks, diff.getY() * i / logChecks, diff.getZ() * i / logChecks);
                this.setBlock((LevelWriter)level, currentPos, log);
            }
            for (x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    int lowerY = 1;
                    if (rand.nextDouble() < Math.sqrt(BlockPos.ZERO.distToLowCornerSqr((double)x, 0.0, (double)z)) / 4.0) {
                        lowerY = 0;
                    }
                    int upperY = Math.min(4, 4 - Math.max(Math.abs(x), Math.abs(z)) + rand.nextInt(2));
                    if (Math.abs(x) == 4 || Math.abs(z) == 4) {
                        lowerY -= Math.abs(rand.nextInt(4) - rand.nextInt(4));
                    }
                    for (int y = lowerY; y <= upperY; ++y) {
                        this.setBlock((LevelWriter)level, topPos.offset(x, y, z), leaves);
                    }
                }
            }
            this.setBlock((LevelWriter)level, topPos.above(), log);
        }
        if (rand.nextInt(25) == 0) {
            BlockPos chestPos = null;
            for (int y = 1; y < 4 && chestPos == null; ++y) {
                int count = 0;
                for (int x4 = 1; x4 < 15; ++x4) {
                    for (int z = 1; z < 15; ++z) {
                        if (!blocks[(x4 * 16 + z) * 4 + y] || rand.nextInt(++count) != 0) continue;
                        chestPos = pos.offset(x4 - 8, y - 3, z - 8);
                    }
                }
            }
            if (chestPos != null) {
                StructureBlockUtil.placeLootChest(chestPos, (LevelAccessor)level, null, Direction.Plane.HORIZONTAL.getRandomDirection(rand), MSLootTables.BASIC_MEDIUM_CHEST, rand);
            }
        }
        return true;
    }

    private boolean hasBlock1(boolean[] blocks, int x, int y, int z, boolean horizontal) {
        if (x > 0 && blocks[((x - 1) * 16 + z) * 4 + y] || x < 15 && blocks[((x + 1) * 16 + z) * 4 + y] || z > 0 && blocks[(x * 16 + (z - 1)) * 4 + y] || z < 15 && blocks[(x * 16 + (z + 1)) * 4 + y]) {
            return true;
        }
        return !horizontal && (y > 0 && blocks[(x * 16 + z) * 4 + y - 1] || y < 3 && blocks[(x * 16 + z) * 4 + y + 1]);
    }

    private boolean hasBlock2(boolean[] blocks, int x, int y, int z) {
        return this.hasBlock1(blocks, x, y, z, true) || x > 0 && this.hasBlock1(blocks, x - 1, y, z, true) || x < 15 && this.hasBlock1(blocks, x + 1, y, z, true) || z > 1 && blocks[(x * 16 + (z - 2)) * 4 + y] || z < 14 && blocks[(x * 16 + (z + 2)) * 4 + y];
    }
}

