/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.block.MSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ParcelPyxisFeature
extends Feature<NoneFeatureConfiguration> {
    public ParcelPyxisFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        Rotation rotation = Rotation.getRandom((RandomSource)rand);
        BlockState parcelPyxis = ((Block)MSBlocks.PARCEL_PYXIS.get()).defaultBlockState().rotate((LevelAccessor)level, pos, rotation);
        if (!parcelPyxis.canSurvive((LevelReader)level, pos)) {
            return false;
        }
        int randInt = 10 + rand.nextInt(5);
        this.setBlock((LevelWriter)level, pos.above(1), parcelPyxis);
        this.setBlock((LevelWriter)level, pos, ((Block)MSBlocks.PIPE_INTERSECTION.get()).defaultBlockState());
        for (int i = 1; i < randInt; ++i) {
            this.setBlock((LevelWriter)level, pos.below(i), ((Block)MSBlocks.PIPE.get()).defaultBlockState());
        }
        this.setBlock((LevelWriter)level, pos.below(randInt), ((Block)MSBlocks.PIPE_INTERSECTION.get()).defaultBlockState());
        if (rand.nextBoolean()) {
            this.setBlock((LevelWriter)level, pos.above(2), ((Block)MSBlocks.PYXIS_LID.get()).defaultBlockState().rotate((LevelAccessor)level, pos, rotation));
        }
        return true;
    }
}

