/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.mojang.serialization.Codec;
import com.mraof.minestuck.util.CoordPair;
import com.mraof.minestuck.world.gen.structure.blocks.StructureBlockRegistry;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class RockSpikeFeature
extends Feature<NoneFeatureConfiguration> {
    private final boolean stomps = false;

    public RockSpikeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource rand;
        int height;
        BlockPos pos;
        WorldGenLevel level = context.level();
        if (!level.getFluidState((pos = context.origin()).above((height = (rand = context.random()).nextInt(7) + 10) * 2 / 3)).isEmpty()) {
            return false;
        }
        float plateauSize = 0.2f + rand.nextFloat() * ((float)height / 25.0f);
        BlockState ground = StructureBlockRegistry.getOrDefault(context.chunkGenerator()).getBlockState("ground");
        BlockPos nodePos = this.generateRock(pos.above(height), height, plateauSize, (LevelAccessor)level, rand, ground);
        float rockRarity = plateauSize + (float)height / 15.0f + rand.nextFloat() * 0.5f - 0.5f;
        if (rockRarity > 1.0f) {
            this.generateSubRock(pos, height, plateauSize, (LevelAccessor)level, rand, ground);
            rockRarity -= 1.0f;
        }
        if (rand.nextFloat() < rockRarity) {
            this.generateSubRock(pos, height, plateauSize, (LevelAccessor)level, rand, ground);
        }
        return true;
    }

    private void generateSubRock(BlockPos pos, int heightOld, float plateauOld, LevelAccessor level, RandomSource rand, BlockState ground) {
        int height = 5 + rand.nextInt((int)((double)(heightOld - 6) * 0.75));
        BlockPos newPos = pos.offset(rand.nextInt(10) - 5, 0, rand.nextInt(10) - 5);
        float plateauSize = rand.nextFloat() * plateauOld * 0.75f;
        this.generateRock(newPos, height, plateauSize, level, rand, ground);
    }

    /*
     * WARNING - void declaration
     */
    private BlockPos generateRock(BlockPos rockPos, int height, float plateauSize, LevelAccessor level, RandomSource random, BlockState ground) {
        BlockPos pos;
        float xSlope = random.nextFloat();
        float zSlope = random.nextFloat();
        HashMap<CoordPair, Integer> heightMap = new HashMap<CoordPair, Integer>();
        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
        HashMap<BlockPos, BlockState> was = new HashMap<BlockPos, BlockState>();
        toProcess.add(rockPos);
        toProcess.add(null);
        while (!toProcess.isEmpty()) {
            CoordPair xz;
            BlockPos pos2 = (BlockPos)toProcess.remove();
            if (pos2 == null) {
                if (toProcess.isEmpty()) break;
                plateauSize = (float)((double)plateauSize - 0.25);
                toProcess.add(null);
                continue;
            }
            if (random.nextFloat() * xSlope < plateauSize) {
                toProcess.add(pos2.west());
            }
            if (random.nextFloat() * (1.0f - xSlope) < plateauSize) {
                toProcess.add(pos2.east());
            }
            if (random.nextFloat() * zSlope < plateauSize) {
                toProcess.add(pos2.north());
            }
            if (random.nextFloat() * (1.0f - zSlope) < plateauSize) {
                toProcess.add(pos2.south());
            }
            if (heightMap.containsKey(xz = new CoordPair(pos2.getX(), pos2.getZ()))) continue;
            heightMap.put(xz, pos2.getY());
        }
        LinkedList<Object> toProcess2 = new LinkedList<Object>();
        int h = 1;
        for (CoordPair coordPair : heightMap.keySet()) {
            if (!RockSpikeFeature.checkCoord(coordPair, heightMap)) continue;
            toProcess2.add(new BlockEntry(coordPair, plateauSize + 0.2f));
        }
        toProcess2.add(null);
        while (!toProcess2.isEmpty()) {
            BlockEntry entry = (BlockEntry)toProcess2.remove();
            if (entry == null) {
                ++h;
                if (toProcess2.isEmpty()) break;
                toProcess2.add(null);
                continue;
            }
            if (!RockSpikeFeature.checkCoord(entry.pos, heightMap)) continue;
            if (random.nextFloat() < entry.spreadChance) {
                void var15_20;
                if (random.nextBoolean()) {
                    CoordPair coordPair = random.nextFloat() < xSlope ? entry.pos.east() : entry.pos.west();
                } else {
                    CoordPair coordPair = random.nextFloat() < zSlope ? entry.pos.south() : entry.pos.north();
                }
                entry.spreadChance -= Math.min(0.5f, 2.0f * (float)h / (float)height);
                if (!heightMap.containsKey(var15_20)) {
                    pos = var15_20.atY(rockPos.getY() - h);
                    heightMap.put((CoordPair)var15_20, rockPos.getY() - h);
                    if (RockSpikeFeature.checkCoord((CoordPair)var15_20, heightMap)) {
                        toProcess2.add(new BlockEntry((CoordPair)var15_20, entry.spreadChance));
                    }
                }
            } else {
                entry.spreadChance += 0.5f;
            }
            if (level.getBlockState(entry.pos.atY(rockPos.getY() - h - 1)).equals(ground)) continue;
            toProcess2.add(entry);
        }
        for (Map.Entry entry : heightMap.entrySet()) {
            pos = ((CoordPair)entry.getKey()).atY((Integer)entry.getValue());
            do {
                was.put(pos, level.getBlockState(pos));
                level.setBlock(pos, ground, 2);
            } while (!level.getBlockState(pos = pos.below()).equals(ground));
        }
        CoordPair nodePos = new CoordPair(rockPos.getX(), rockPos.getZ());
        boolean bl = false;
        for (int i = 0; i < 9; ++i) {
            int n;
            CoordPair coords = new CoordPair(rockPos.getX() + i % 3 - 1, rockPos.getZ() + i / 3 - 1);
            int blockCount = 0;
            for (int i1 = 0; i1 < 4; ++i1) {
                Integer coordsHeight = (Integer)heightMap.get(new CoordPair(coords.x() + i1 % 2, coords.z() + i1 / 2));
                if (coordsHeight == null || coordsHeight.intValue() != rockPos.getY()) continue;
                ++blockCount;
            }
            if (blockCount <= n) continue;
            nodePos = coords;
            n = blockCount;
        }
        BlockPos corePosition = nodePos.atY(rockPos.getY() + 1);
        return corePosition;
    }

    private static boolean checkCoord(CoordPair pair, Map<CoordPair, Integer> map) {
        return !map.containsKey(pair.north()) || !map.containsKey(pair.east()) || !map.containsKey(pair.south()) || !map.containsKey(pair.west());
    }

    private static /* synthetic */ void lambda$generateRock$0(LevelAccessor level, BlockPos t, BlockState u) {
        level.setBlock(t, u, 2);
    }

    private static class BlockEntry {
        private final CoordPair pos;
        private float spreadChance;

        private BlockEntry(CoordPair pos, float spreadChance) {
            this.pos = pos;
            this.spreadChance = spreadChance;
        }
    }
}

