/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.world.gen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mraof.minestuck.world.gen.feature.TemplatePlacement;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SmallLibraryFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceLocation STRUCTURE_SMALL_LIBRARY = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"small_library");

    public SmallLibraryFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource rand = context.random();
        StructureTemplateManager templates = level.getLevel().getStructureManager();
        StructureTemplate template = templates.getOrCreate(STRUCTURE_SMALL_LIBRARY);
        TemplatePlacement placement = TemplatePlacement.centeredWithRandomRotation(template, context.origin(), rand);
        StructurePlaceSettings settings = new StructurePlaceSettings();
        if (rand.nextBoolean()) {
            settings.addProcessor((StructureProcessor)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.BOOKSHELF, 0.2f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()))));
        }
        int centerX = template.getSize().getX() / 2;
        int endZ = template.getSize().getZ() - 1;
        int door1Height = TemplatePlacement.maxHeight(Heightmap.Types.OCEAN_FLOOR_WG, (LevelReader)level, placement.xzRange(centerX - 1, 0, centerX + 1, 0));
        int door2Height = TemplatePlacement.maxHeight(Heightmap.Types.OCEAN_FLOOR_WG, (LevelReader)level, placement.xzRange(centerX - 1, endZ, centerX + 1, endZ));
        placement.placeWithStructureBlockRegistryAt(Math.min(door1Height, door2Height) - 1, context, settings);
        return true;
    }
}

